/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.reliable;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Date;
import java.util.Iterator;
import javax.jms.JMSException;
import org.activemq.message.KeepAlive;
import org.activemq.transport.reliable.ReliableTransportChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeepAliveDaemon
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)KeepAliveDaemon.class);
    private static KeepAliveDaemon instance = null;
    private long checkInterval = 15000L;
    private long lastCheck = 0L;
    private Object lock = new Object();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private SynchronizedBoolean stopped = new SynchronizedBoolean(false);
    private CopyOnWriteArraySet monitoredChannels = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet zombieChannelSuspects = new CopyOnWriteArraySet();

    protected KeepAliveDaemon() {
    }

    public static synchronized KeepAliveDaemon getInstance() {
        if (instance == null) {
            instance = new KeepAliveDaemon();
        }
        return instance;
    }

    public void addMonitoredChannel(ReliableTransportChannel channel) {
        if (channel.getKeepAliveTimeout() <= 0L) {
            return;
        }
        log.debug((Object)("Adding channel " + channel));
        if (channel.getKeepAliveTimeout() / 2L < this.checkInterval) {
            this.setCheckInterval(channel.getKeepAliveTimeout() / 2L);
            log.info((Object)("Adjusting check interval to " + this.checkInterval + " as channel " + channel.toString() + " has lower timeout time than the current check interval."));
        }
        this.monitoredChannels.add((Object)channel);
    }

    public void removeMonitoredChannel(ReliableTransportChannel channel) {
        log.debug((Object)("Removing channel " + channel));
        this.monitoredChannels.remove((Object)channel);
    }

    public void setCheckInterval(long interval) {
        this.checkInterval = interval;
        if (this.started.and(!this.stopped.get())) {
            this.restart();
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public long getLastCheckTime() {
        return this.lastCheck;
    }

    public void start() {
        if (this.started.commit(false, true)) {
            log.debug((Object)("Scheduling keep-alive every " + this.checkInterval + " millisecond."));
            Thread t = new Thread(this);
            t.setName("KeepAliveDaemon");
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped.commit(false, true)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            log.debug((Object)"Stopping keep-alive.");
        }
    }

    public void restart() {
        log.debug((Object)"Restarting keep-alive.");
        this.stop();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.lastCheck = System.currentTimeMillis() - this.checkInterval;
        while (!this.stopped.get()) {
            ReliableTransportChannel channel;
            Iterator i = this.zombieChannelSuspects.iterator();
            while (i.hasNext()) {
                channel = (ReliableTransportChannel)i.next();
                this.examineZombieSuspect(channel);
            }
            i = this.monitoredChannels.iterator();
            while (i.hasNext()) {
                channel = (ReliableTransportChannel)i.next();
                if (this.zombieChannelSuspects.contains((Object)channel)) continue;
                this.examineChannel(channel);
            }
            this.lastCheck = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(this.checkInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void examineZombieSuspect(ReliableTransportChannel channel) {
        if (channel.getLastReceiptTimestamp() + channel.getKeepAliveTimeout() * 2L < System.currentTimeMillis()) {
            log.info((Object)("Forcing channel " + channel + " to disconnect since it " + (channel.getLastReceiptTimestamp() == 0L ? "never has responded " : "hasn't responded since " + new Date(channel.getLastReceiptTimestamp())) + " and has a timeout of " + channel.getKeepAliveTimeout()));
            channel.forceDisconnect();
            this.zombieChannelSuspects.remove((Object)channel);
        } else if (channel.getLastReceiptTimestamp() + channel.getKeepAliveTimeout() < System.currentTimeMillis()) {
            log.debug((Object)("Still waiting for response from channel " + channel));
        } else {
            log.debug((Object)("Channel " + channel + " responded in time."));
            this.zombieChannelSuspects.remove((Object)channel);
        }
    }

    private void examineChannel(ReliableTransportChannel channel) {
        block5: {
            if (channel.isPendingStop()) {
                this.removeMonitoredChannel(channel);
            } else if (channel.getLastReceiptTimestamp() + channel.getKeepAliveTimeout() < System.currentTimeMillis()) {
                log.debug((Object)("Sending keep-alive on channel " + channel.toString()));
                KeepAlive packet = new KeepAlive();
                packet.setReceiptRequired(true);
                boolean wasConnected = channel.isTransportConnected();
                try {
                    channel.asyncSendWithReceipt(packet);
                    this.zombieChannelSuspects.add((Object)channel);
                }
                catch (JMSException e) {
                    if (!wasConnected) break block5;
                    log.error((Object)("Error sending keep-alive to channel " + channel.toString() + ". Treating as temporary problem."), (Throwable)e);
                }
            }
        }
    }
}

