/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.cache;

import javax.jms.JMSException;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.MessageIdentity;
import org.activemq.service.SubscriberEntry;
import org.activemq.store.RecoveryListener;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.cache.CacheMessageStore;
import org.activemq.store.cache.CachePersistenceAdapter;
import org.activemq.store.cache.MessageCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheTopicMessageStore
extends CacheMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog((Class)CacheTopicMessageStore.class);
    private final TopicMessageStore longTermStore;

    public CacheTopicMessageStore(CachePersistenceAdapter adapter, TopicMessageStore longTermStore, MessageCache cache) {
        super(adapter, longTermStore, cache);
        this.longTermStore = longTermStore;
    }

    public void setLastAcknowledgedMessageIdentity(String subscription, MessageIdentity messageIdentity) throws JMSException {
        this.longTermStore.setLastAcknowledgedMessageIdentity(subscription, messageIdentity);
    }

    public MessageIdentity getLastestMessageIdentity() throws JMSException {
        return this.longTermStore.getLastestMessageIdentity();
    }

    public synchronized void recoverSubscription(String subscriptionId, MessageIdentity lastDispatchedMessage, RecoveryListener listener) throws JMSException {
        this.longTermStore.recoverSubscription(subscriptionId, lastDispatchedMessage, listener);
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
        this.longTermStore.setSubscriberEntry(info, subscriberEntry);
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        return this.longTermStore.getSubscriberEntry(info);
    }

    public void incrementMessageCount(MessageIdentity messageId) throws JMSException {
        this.longTermStore.incrementMessageCount(messageId);
    }

    public void decrementMessageCountAndMaybeDelete(MessageIdentity msgId) throws JMSException {
        this.longTermStore.decrementMessageCountAndMaybeDelete(msgId);
    }

    public void deleteSubscription(String subcription) throws JMSException {
        this.longTermStore.deleteSubscription(subcription);
    }
}

