/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.activemq.ActiveMQSession;
import org.activemq.filter.DestinationFilter;
import org.activemq.filter.DestinationPath;
import org.activemq.jndi.JNDIBaseStorable;
import org.activemq.management.JMSDestinationStats;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTemporaryQueue;
import org.activemq.message.ActiveMQTemporaryTopic;
import org.activemq.message.ActiveMQTopic;

public abstract class ActiveMQDestination
extends JNDIBaseStorable
implements Destination,
Comparable,
Serializable {
    public static final int ACTIVEMQ_TOPIC = 1;
    public static final int ACTIVEMQ_TEMPORARY_TOPIC = 2;
    public static final int ACTIVEMQ_QUEUE = 3;
    public static final int ACTIVEMQ_TEMPORARY_QUEUE = 4;
    public static final String ADVISORY_PREFIX = "ActiveMQ.Advisory.";
    public static final String CONNECTION_ADVISORY_PREFIX = "ActiveMQ.Advisory.Connections.";
    public static final String CONSUMER_ADVISORY_PREFIX = "ActiveMQ.Advisory.Consumers.";
    public static final String PRODUCER_ADVISORY_PREFIX = "ActiveMQ.Advisory.Producers.";
    public static final String TEMP_DESTINATION_ADVISORY_PREFIX = "ActiveMQ.Advisory.TempDestinations.";
    public static final String DEFAULT_ORDERED_TARGET = "coordinator";
    private static final int NULL_DESTINATION = 10;
    private static final String TEMP_PREFIX = "{TD{";
    private static final String TEMP_POSTFIX = "}TD}";
    private static final String COMPOSITE_SEPARATOR = ",";
    private static final String QUEUE_PREFIX = "queue://";
    private static final String TOPIC_PREFIX = "topic://";
    private String physicalName = "";
    private transient DestinationFilter filter;
    private transient JMSDestinationStats stats;
    private transient String[] paths;
    private transient int consumerCounter;
    private transient boolean deleted;
    private boolean exclusive;
    private boolean ordered;
    private boolean advisory;
    private boolean wildcard;
    private boolean composite;
    private String orderedTarget = "coordinator";
    private transient ActiveMQSession sessionCreatedBy;

    public ActiveMQSession getSessionCreatedBy() {
        return this.sessionCreatedBy;
    }

    public void setSessionCreatedBy(ActiveMQSession orginatingSession) {
        this.sessionCreatedBy = orginatingSession;
    }

    protected ActiveMQDestination() {
    }

    protected ActiveMQDestination(String name) {
        this.setPhysicalName(name);
    }

    public final boolean isAdvisory() {
        return this.advisory;
    }

    public final void setAdvisory(boolean advisory) {
        this.advisory = advisory;
    }

    public boolean isConsumerAdvisory() {
        return this.isAdvisory() && this.physicalName.startsWith(CONSUMER_ADVISORY_PREFIX);
    }

    public boolean isProducerAdvisory() {
        return this.isAdvisory() && this.physicalName.startsWith(PRODUCER_ADVISORY_PREFIX);
    }

    public boolean isConnectionAdvisory() {
        return this.isAdvisory() && this.physicalName.startsWith(CONNECTION_ADVISORY_PREFIX);
    }

    public final boolean isTempDestinationAdvisory() {
        return this.advisory && this.physicalName.startsWith(TEMP_DESTINATION_ADVISORY_PREFIX);
    }

    public final boolean isExclusive() {
        return this.exclusive;
    }

    public final void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public final boolean isOrdered() {
        return this.ordered;
    }

    public final void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public String getOrderedTarget() {
        return this.orderedTarget;
    }

    public void setOrderedTarget(String orderedTarget) {
        this.orderedTarget = orderedTarget;
    }

    public static String inspect(Destination destination) {
        if (destination instanceof Topic) {
            return "Topic(" + destination.toString() + ")";
        }
        return "Queue(" + destination.toString() + ")";
    }

    public static ActiveMQDestination transformDestination(Destination destination) throws JMSException {
        ActiveMQDestination result = null;
        if (destination != null) {
            if (destination instanceof ActiveMQDestination) {
                result = (ActiveMQDestination)destination;
            } else if (destination instanceof TemporaryQueue) {
                result = new ActiveMQTemporaryQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                result = new ActiveMQTemporaryTopic(((Topic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                result = new ActiveMQTemporaryQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                result = new ActiveMQTemporaryTopic(((Topic)destination).getTopicName());
            }
        }
        return result;
    }

    public static void writeToStream(ActiveMQDestination destination, DataOutput dataOut) throws IOException {
        if (destination != null) {
            dataOut.writeByte(destination.getDestinationType());
            String physicalName = destination.getPhysicalName();
            boolean writeOrderedTarget = destination.orderedTarget != null && !destination.orderedTarget.equals(DEFAULT_ORDERED_TARGET);
            byte byte1 = 0;
            if (physicalName != null || physicalName.length() > 0) {
                byte1 = (byte)(byte1 | 1);
            }
            if (destination.ordered) {
                byte1 = (byte)(byte1 | 2);
            }
            if (destination.exclusive) {
                byte1 = (byte)(byte1 | 4);
            }
            if (writeOrderedTarget) {
                byte1 = (byte)(byte1 | 8);
            }
            if (destination.advisory) {
                byte1 = (byte)(byte1 | 0x10);
            }
            if (destination.deleted) {
                byte1 = (byte)(byte1 | 0x20);
            }
            if (destination.composite) {
                byte1 = (byte)(byte1 | 0x40);
            }
            if (destination.wildcard) {
                byte1 = (byte)(byte1 | 0x80);
            }
            dataOut.writeByte(byte1);
            if (physicalName != null || physicalName.length() > 0) {
                dataOut.writeUTF(physicalName);
            }
            if (writeOrderedTarget) {
                dataOut.writeUTF(destination.orderedTarget);
            }
        } else {
            dataOut.write(10);
        }
    }

    public static ActiveMQDestination readFromStream(DataInput dataIn) throws IOException {
        byte type = dataIn.readByte();
        if (type == 10) {
            return null;
        }
        ActiveMQDestination result = null;
        result = type == 1 ? new ActiveMQTopic() : (type == 2 ? new ActiveMQTemporaryTopic() : (type == 3 ? new ActiveMQQueue() : new ActiveMQTemporaryQueue()));
        byte byte1 = dataIn.readByte();
        if ((byte1 & 1) == 1) {
            result.physicalName = dataIn.readUTF();
        }
        result.setOrdered((byte1 & 2) == 2);
        result.setExclusive((byte1 & 4) == 4);
        if ((byte1 & 8) == 8) {
            result.setOrderedTarget(dataIn.readUTF());
        }
        result.advisory = (byte1 & 0x10) == 16;
        result.deleted = (byte1 & 0x20) == 32;
        result.composite = (byte1 & 0x40) == 64;
        result.wildcard = (byte1 & 0x80) == 128;
        return result;
    }

    public static ActiveMQDestination createDestination(int type, String pyhsicalName) {
        ActiveMQDestination result = null;
        result = type == 1 ? new ActiveMQTopic(pyhsicalName) : (type == 2 ? new ActiveMQTemporaryTopic(pyhsicalName) : (type == 3 ? new ActiveMQQueue(pyhsicalName) : new ActiveMQTemporaryQueue(pyhsicalName)));
        return result;
    }

    public static String createTemporaryName(String clientId) {
        return TEMP_PREFIX + clientId + TEMP_POSTFIX;
    }

    public static String getClientId(ActiveMQDestination destination) {
        int stop;
        String name;
        int start;
        String answer = null;
        if (destination != null && destination.isTemporary() && (start = (name = destination.getPhysicalName()).indexOf(TEMP_PREFIX)) >= 0 && (stop = name.lastIndexOf(TEMP_POSTFIX)) > (start += TEMP_PREFIX.length()) && stop < name.length()) {
            answer = name.substring(start, stop);
        }
        return answer;
    }

    public int compareTo(Object o) {
        if (o instanceof ActiveMQDestination) {
            return this.compareTo((ActiveMQDestination)o);
        }
        return -1;
    }

    public int compareTo(ActiveMQDestination that) {
        int answer = 0;
        if (this.physicalName != that.physicalName) {
            if (this.physicalName == null) {
                return -1;
            }
            if (that.physicalName == null) {
                return 1;
            }
            answer = this.physicalName.compareTo(that.physicalName);
        }
        if (answer == 0) {
            if (this.isTopic()) {
                if (that.isQueue()) {
                    return 1;
                }
            } else if (that.isTopic()) {
                return -1;
            }
        }
        return answer;
    }

    public abstract int getDestinationType();

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String name) {
        this.physicalName = name;
        this.advisory = name != null && name.startsWith(ADVISORY_PREFIX);
        this.composite = name != null && name.indexOf(COMPOSITE_SEPARATOR) > 0;
        this.wildcard = name != null && (name.indexOf("*") >= 0 || name.indexOf(">") >= 0);
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean isTopic() {
        return true;
    }

    public boolean isQueue() {
        return false;
    }

    public final boolean isComposite() {
        return this.composite;
    }

    public List getChildDestinations() {
        ArrayList<ActiveMQDestination> answer = new ArrayList<ActiveMQDestination>();
        StringTokenizer iter = new StringTokenizer(this.physicalName, COMPOSITE_SEPARATOR);
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken();
            ActiveMQDestination child = null;
            child = name.startsWith(QUEUE_PREFIX) ? new ActiveMQQueue(name.substring(QUEUE_PREFIX.length())) : (name.startsWith(TOPIC_PREFIX) ? new ActiveMQTopic(name.substring(TOPIC_PREFIX.length())) : this.createDestination(name));
            answer.add(child);
        }
        if (answer.size() == 1) {
            answer.set(0, this);
        }
        return answer;
    }

    public void setChildDestinations(ActiveMQDestination[] children) {
        if (children == null) {
            throw new IllegalArgumentException("children array cannot be null.");
        }
        if (children.length == 0) {
            throw new IllegalArgumentException("children array size must be 1 or greater.");
        }
        StringBuffer rc = new StringBuffer();
        for (int i = 0; i < children.length; ++i) {
            if (i != 0) {
                rc.append(COMPOSITE_SEPARATOR);
            }
            if (children[i].isTopic()) {
                rc.append(TOPIC_PREFIX);
            } else if (children[i].isQueue()) {
                rc.append(QUEUE_PREFIX);
            }
            rc.append(children[i].getPhysicalName());
        }
        this.setPhysicalName(rc.toString());
    }

    public String toString() {
        return this.physicalName;
    }

    public int hashCode() {
        int answer = -889275714;
        if (this.physicalName != null) {
            answer = this.physicalName.hashCode();
        }
        if (this.isTopic()) {
            answer ^= 0xFABFAB;
        }
        return answer;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof ActiveMQDestination) {
            ActiveMQDestination other = (ActiveMQDestination)obj;
            result = this.getDestinationType() == other.getDestinationType() && this.physicalName.equals(other.physicalName);
        }
        return result;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public boolean matches(ActiveMQDestination destination) {
        if (this.isWildcard()) {
            return this.getDestinationFilter().matches(destination);
        }
        return this.equals(destination);
    }

    public DestinationFilter getDestinationFilter() {
        if (this.filter == null) {
            this.filter = DestinationFilter.parseFilter(this);
        }
        return this.filter;
    }

    public String[] getDestinationPaths() {
        if (this.paths == null) {
            this.paths = DestinationPath.getDestinationPaths(this.physicalName);
        }
        return this.paths;
    }

    public JMSDestinationStats getStats() {
        if (this.stats == null) {
            this.stats = this.createDestinationStats();
        }
        return this.stats;
    }

    public void setStats(JMSDestinationStats stats) {
        this.stats = stats;
    }

    public synchronized void incrementConsumerCounter() {
        ++this.consumerCounter;
    }

    public synchronized void decrementConsumerCounter() {
        --this.consumerCounter;
    }

    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    public synchronized void setDeleted(boolean value) {
        this.deleted = value;
    }

    public synchronized void delete() throws JMSException {
        if (this.consumerCounter != 0) {
            throw new JMSException("A consumer is still using this temporary queue.");
        }
        if (this.sessionCreatedBy != null) {
            this.sessionCreatedBy.removeTemporaryDestination(this);
        }
        this.deleted = true;
    }

    protected abstract Destination createDestination(String var1);

    protected abstract JMSDestinationStats createDestinationStats();

    protected void buildFromProperties(Properties props) {
        this.physicalName = props.getProperty("physicalName", this.physicalName);
    }

    protected void populateProperties(Properties props) {
        props.put("physicalName", this.physicalName);
    }

    public ActiveMQTopic getTopicForTempAdvisory() {
        String destName = TEMP_DESTINATION_ADVISORY_PREFIX + this.getAdvisoryDestinationTypePrefix() + this.getPhysicalName();
        return new ActiveMQTopic(destName);
    }

    public ActiveMQTopic getTopicForConsumerAdvisory() {
        String destName = CONSUMER_ADVISORY_PREFIX + this.getAdvisoryDestinationTypePrefix() + this.getPhysicalName();
        return new ActiveMQTopic(destName);
    }

    public ActiveMQTopic getTopicForProducerAdvisory() {
        String destName = PRODUCER_ADVISORY_PREFIX + this.getAdvisoryDestinationTypePrefix() + this.getPhysicalName();
        return new ActiveMQTopic(destName);
    }

    public ActiveMQDestination getDestinationBeingAdvised() {
        if (this.isConnectionAdvisory()) {
            return null;
        }
        if (this.isConsumerAdvisory()) {
            String matchName = this.physicalName.substring(CONSUMER_ADVISORY_PREFIX.length());
            return this.createDestinationFromAdvisoryName(matchName);
        }
        if (this.isProducerAdvisory()) {
            String matchName = this.physicalName.substring(PRODUCER_ADVISORY_PREFIX.length());
            return this.createDestinationFromAdvisoryName(matchName);
        }
        if (this.isTempDestinationAdvisory()) {
            String matchName = this.physicalName.substring(TEMP_DESTINATION_ADVISORY_PREFIX.length());
            return this.createDestinationFromAdvisoryName(matchName);
        }
        return null;
    }

    private String getAdvisoryDestinationTypePrefix() {
        switch (this.getDestinationType()) {
            case 1: {
                return "topic.";
            }
            case 3: {
                return "queue.";
            }
            case 2: {
                return "temp-topic.";
            }
            case 4: {
                return "temp-queue.";
            }
        }
        throw new RuntimeException("Invlaid destiantion type: " + this.getDestinationType());
    }

    private ActiveMQDestination createDestinationFromAdvisoryName(String advisoryName) {
        if (advisoryName.startsWith("topic.")) {
            String name = advisoryName.substring("topic.".length());
            return ActiveMQDestination.createDestination(1, name);
        }
        if (advisoryName.startsWith("queue.")) {
            String name = advisoryName.substring("queue.".length());
            return ActiveMQDestination.createDestination(3, name);
        }
        if (advisoryName.startsWith("temp-topic.")) {
            String name = advisoryName.substring("temp-topic.".length());
            return ActiveMQDestination.createDestination(2, name);
        }
        if (advisoryName.startsWith("temp-queue.")) {
            String name = advisoryName.substring("temp-queue.".length());
            return ActiveMQDestination.createDestination(4, name);
        }
        return null;
    }
}

