/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedShort;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.CachedValueWriter;
import org.activemq.io.impl.PacketReader;
import org.activemq.io.impl.PacketWriter;
import org.activemq.io.util.WireByteArrayInputStream;
import org.activemq.io.util.WireByteArrayOutputStream;
import org.activemq.message.CachedValue;
import org.activemq.message.Packet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWireFormat
extends AbstractDefaultWireFormat
implements Serializable {
    private static final int MAX_CACHE_SIZE = 16383;
    private static final Log log = LogFactory.getLog((Class)DefaultWireFormat.class);
    static final short NULL_VALUE = -1;
    static final short CLEAR_CACHE = -2;
    protected final transient Object writeMutex = new Object();
    protected transient WireByteArrayOutputStream internalBytesOut;
    protected transient DataOutputStream internalDataOut;
    protected transient WireByteArrayOutputStream cachedBytesOut;
    protected transient DataOutputStream cachedDataOut;
    private Map writeValueCache = new HashMap();
    protected transient SynchronizedShort cachedKeyGenerator;
    protected final transient Object readMutex = new Object();
    protected transient WireByteArrayInputStream internalBytesIn;
    protected transient DataInputStream internalDataIn;
    private Map readValueCache = new HashMap();

    public DefaultWireFormat() {
        this.internalBytesOut = new WireByteArrayOutputStream();
        this.internalDataOut = new DataOutputStream(this.internalBytesOut);
        this.internalBytesIn = new WireByteArrayInputStream();
        this.internalDataIn = new DataInputStream(this.internalBytesIn);
        this.currentWireFormatVersion = 3;
        this.cachedKeyGenerator = new SynchronizedShort(0);
        this.cachedBytesOut = new WireByteArrayOutputStream();
        this.cachedDataOut = new DataOutputStream(this.cachedBytesOut);
    }

    public WireFormat copy() {
        return new DefaultWireFormat();
    }

    private Object readResolve() throws ObjectStreamException {
        return new DefaultWireFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet writePacket(Packet packet, DataOutput dataOut) throws IOException {
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            Object object = this.writeMutex;
            synchronized (object) {
                this.internalBytesOut.reset();
                writer.writePacket(packet, this.internalDataOut);
                this.internalDataOut.flush();
                byte[] data = this.internalBytesOut.getData();
                int count = this.internalBytesOut.size();
                dataOut.writeByte(packet.getPacketType());
                dataOut.writeInt(count);
                packet.setMemoryUsage(count);
                dataOut.write(data, 0, count);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized Packet readPacket(DataInput dataIn, PacketReader reader) throws IOException {
        Object object = this.readMutex;
        synchronized (object) {
            Packet packet = reader.createPacket();
            int length = dataIn.readInt();
            packet.setMemoryUsage(length);
            byte[] data = new byte[length];
            dataIn.readFully(data);
            this.internalBytesIn.restart(data);
            reader.buildPacket(packet, this.internalDataIn);
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Packet packet) throws IOException {
        byte[] data = null;
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            Object object = this.writeMutex;
            synchronized (object) {
                this.internalBytesOut.reset();
                this.internalDataOut.writeByte(packet.getPacketType());
                this.internalDataOut.writeInt(-1);
                writer.writePacket(packet, this.internalDataOut);
                this.internalDataOut.flush();
                data = this.internalBytesOut.toByteArray();
            }
            int length = data.length - 5;
            packet.setMemoryUsage(length);
            data[1] = (byte)(length >>> 24 & 0xFF);
            data[2] = (byte)(length >>> 16 & 0xFF);
            data[3] = (byte)(length >>> 8 & 0xFF);
            data[4] = (byte)(length >>> 0 & 0xFF);
        }
        return data;
    }

    public Object getValueFromReadCache(short key) {
        return this.readValueCache.get(new Short(key));
    }

    protected short getWriteCachedKey(Object key) throws IOException {
        if (key != null) {
            Short result = null;
            result = (Short)this.writeValueCache.get(key);
            if (result == null) {
                result = new Short(this.cachedKeyGenerator.increment());
                this.writeValueCache.put(key, result);
                this.updateCachedValue(result, key);
            }
            return result;
        }
        return -1;
    }

    protected void validateWriteCache() throws IOException {
        if (this.cachingEnabled && this.writeValueCache.size() >= 16383) {
            this.writeValueCache.clear();
            this.cachedKeyGenerator.set((short)0);
            this.updateCachedValue((short)-1, null);
        }
    }

    protected void handleCachedValue(CachedValue cv) {
        if (cv != null) {
            if (cv.getId() == -2) {
                this.readValueCache.clear();
            } else if (cv.getId() != -1) {
                this.readValueCache.put(new Short(cv.getId()), cv.getValue());
            }
        }
    }

    private synchronized void updateCachedValue(short key, Object value) throws IOException {
        if (this.cachedValueWriter == null) {
            this.cachedValueWriter = new CachedValueWriter();
        }
        CachedValue cv = new CachedValue();
        cv.setId(key);
        cv.setValue(value);
        this.cachedBytesOut.reset();
        this.cachedValueWriter.writePacket(cv, this.cachedDataOut);
        this.cachedDataOut.flush();
        byte[] data = this.cachedBytesOut.getData();
        int count = this.cachedBytesOut.size();
        this.getTransportDataOut().writeByte(cv.getPacketType());
        this.getTransportDataOut().writeInt(count);
        this.getTransportDataOut().write(data, 0, count);
    }
}

