/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import org.activemq.io.impl.AbstractPacketWriter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.Packet;

public class ConsumerInfoWriter
extends AbstractPacketWriter {
    public int getPacketType() {
        return 17;
    }

    public void writePacket(Packet packet, DataOutput dataOut) throws IOException {
        super.writePacket(packet, dataOut);
        ConsumerInfo info = (ConsumerInfo)packet;
        super.writeUTF(info.getConsumerId(), dataOut);
        super.writeUTF(info.getClientId(), dataOut);
        dataOut.writeShort(info.getSessionId());
        super.writeUTF(info.getSelector(), dataOut);
        super.writeUTF(info.getConsumerName(), dataOut);
        dataOut.writeInt(info.getConsumerNo());
        dataOut.writeShort(info.getPrefetchNumber());
        dataOut.writeLong(info.getStartTime());
        dataOut.writeBoolean(info.isStarted());
        dataOut.writeBoolean(info.isReceiptRequired());
        dataOut.writeBoolean(info.isNoLocal());
        dataOut.writeBoolean(info.isBrowser());
        ActiveMQDestination.writeToStream(info.getDestination(), dataOut);
    }
}

