/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static final Log log = LogFactory.getLog((Class)BeanUtils.class);
    protected static final String NAME = "org.apache.commons.beanutils.BeanUtils";
    protected static final Class[] PARAMETER_TYPES = new Class[]{Object.class, Map.class};

    public static void populate(Object bean, Map properties) {
        Class<?> beanUtils = null;
        try {
            beanUtils = Thread.currentThread().getContextClassLoader().loadClass(NAME);
        }
        catch (ClassNotFoundException e) {
            try {
                beanUtils = BeanUtils.class.getClassLoader().loadClass(NAME);
            }
            catch (ClassNotFoundException e1) {
                log.trace((Object)("Cannot find: org.apache.commons.beanutils.BeanUtils. Reason: " + e), (Throwable)e);
            }
        }
        if (beanUtils == null) {
            log.warn((Object)("Could not find class: org.apache.commons.beanutils.BeanUtils so cannot configure bean using introspection: " + bean));
        } else {
            Method method = null;
            try {
                method = beanUtils.getMethod("populate", PARAMETER_TYPES);
            }
            catch (NoSuchMethodException e) {
                log.trace((Object)"Could not find populate", (Throwable)e);
            }
            if (method == null) {
                log.warn((Object)("Could not find populate() method so cannot configure bean using introspection: " + bean));
            } else {
                try {
                    method.invoke(null, bean, properties);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not populate the bean via introspection: " + bean + ". Reason: " + e), (Throwable)e);
                }
            }
        }
    }
}

