/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.activeio.journal.RecordLocation;
import org.activemq.message.ActiveMQXid;
import org.activemq.store.TransactionStore;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.store.journal.TxCommand;
import org.activemq.util.TransactionTemplate;

public class JournalTransactionStore
implements TransactionStore {
    private final JournalPersistenceAdapter peristenceAdapter;
    final TransactionStore checkpointStore;
    ConcurrentHashMap inflightTransactions = new ConcurrentHashMap();
    ConcurrentHashMap preparedTransactions = new ConcurrentHashMap();
    private TransactionTemplate transactionTemplate;

    public JournalTransactionStore(JournalPersistenceAdapter adapter, TransactionStore checkpointStore) {
        this.peristenceAdapter = adapter;
        this.checkpointStore = checkpointStore;
        this.transactionTemplate = new TransactionTemplate(adapter);
    }

    public void transactionStarted(Object txid, RecordLocation txStartLocation) {
        if (this.inflightTransactions.get(txid) == null) {
            this.inflightTransactions.put(txid, (Object)txStartLocation);
        }
    }

    public void prepare(Object txid) throws XAException {
        Object location = this.inflightTransactions.remove(txid);
        if (location == null) {
            return;
        }
        this.peristenceAdapter.writeTxCommand(new TxCommand(1, txid, false), true);
        this.preparedTransactions.put(txid, location);
        this.checkpointStore.prepare(txid);
    }

    public void commit(Object txid, boolean wasPrepared) throws XAException {
        Object location = wasPrepared ? this.preparedTransactions.remove(txid) : this.inflightTransactions.remove(txid);
        if (location == null) {
            return;
        }
        if (txid.getClass() == ActiveMQXid.class) {
            this.peristenceAdapter.writeTxCommand(new TxCommand(2, txid, wasPrepared), true);
        } else {
            this.peristenceAdapter.writeTxCommand(new TxCommand(4, txid, wasPrepared), true);
        }
        this.checkpointStore.commit(txid, wasPrepared);
    }

    public void rollback(Object txid) throws XAException {
        if (txid.getClass() == ActiveMQXid.class) {
            this.peristenceAdapter.writeTxCommand(new TxCommand(3, txid, false), true);
        } else {
            this.peristenceAdapter.writeTxCommand(new TxCommand(5, txid, false), true);
        }
        this.preparedTransactions.remove(txid);
        this.inflightTransactions.remove(txid);
        this.checkpointStore.rollback(txid);
    }

    public void recover(TransactionStore.RecoveryListener listener) throws XAException {
        this.checkpointStore.recover(listener);
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public RecordLocation checkpoint() throws JMSException {
        RecordLocation location;
        RecordLocation rc = null;
        Iterator iter = this.inflightTransactions.values().iterator();
        while (iter.hasNext()) {
            location = (RecordLocation)iter.next();
            if (rc != null && rc.compareTo((Object)location) >= 0) continue;
            rc = location;
        }
        iter = this.preparedTransactions.values().iterator();
        while (iter.hasNext()) {
            location = (RecordLocation)iter.next();
            if (rc != null && rc.compareTo((Object)location) >= 0) continue;
            rc = location;
        }
        return rc;
    }
}

