/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.MessageIdentity;
import org.activemq.service.SubscriberEntry;
import org.activemq.store.RecoveryListener;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCMessageStore;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog((Class)JDBCTopicMessageStore.class);

    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, String destinationName) {
        super(persistenceAdapter, adapter, wireFormat, destinationName);
    }

    public void setLastAcknowledgedMessageIdentity(String subscription, MessageIdentity messageIdentity) throws JMSException {
        long seq = this.getMessageSequenceId(messageIdentity);
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doSetLastAck(c, this.destinationName, subscription, seq);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to store ack for: " + subscription + " on message " + messageIdentity + " in container: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public MessageIdentity getLastestMessageIdentity() throws JMSException {
        return new MessageIdentity(null, new Long(this.sequenceGenerator.getLastSequenceId()));
    }

    public void recoverSubscription(String subscriptionId, MessageIdentity lastDispatchedMessage, final RecoveryListener listener) throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRecoverSubscription(c, this.destinationName, subscriptionId, new JDBCAdapter.MessageListResultHandler(){

                public void onMessage(long seq, String messageID) throws JMSException {
                    MessageIdentity messageIdentity = new MessageIdentity(messageID, new Long(seq));
                    listener.recoverMessage(messageIdentity);
                }
            });
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to recover subscription: " + subscriptionId + ". Reason: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
        String key = info.getConsumerKey();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doSetSubscriberEntry(c, this.destinationName, key, subscriberEntry);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to lookup subscription for info: " + info + ". Reason: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        String key = info.getConsumerKey();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            SubscriberEntry subscriberEntry = this.adapter.doGetSubscriberEntry(c, this.destinationName, key);
            return subscriberEntry;
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to lookup subscription for info: " + info + ". Reason: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void deleteSubscription(String subscription) throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doDeleteSubscription(c, this.destinationName, subscription);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to remove subscription for: " + subscription + ". Reason: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void incrementMessageCount(MessageIdentity messageId) throws JMSException {
    }

    public void decrementMessageCountAndMaybeDelete(MessageIdentity messageIdentity) throws JMSException {
    }
}

