/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activemq.filter.DestinationMapNode;
import org.activemq.message.ActiveMQDestination;

public class DestinationMap {
    private DestinationMapNode rootNode = new DestinationMapNode();
    private Map vanillaDestinations = new ConcurrentHashMap();
    private boolean containsWildCards = false;
    protected static final String ANY_DESCENDENT = ">";
    protected static final String ANY_CHILD = "*";
    private Set nullAnswer = new HashSet();

    public synchronized Set get(ActiveMQDestination key) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            HashSet<Set> answer = new HashSet<Set>(childDestinations.size());
            Iterator iter = childDestinations.iterator();
            if (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                Set value = this.get(childDestination);
                if (value instanceof Set) {
                    answer.addAll(value);
                } else if (value != null) {
                    answer.add(value);
                }
                return answer;
            }
        }
        return this.findWildcardMatches(key);
    }

    public synchronized void put(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            Iterator iter = childDestinations.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                this.put(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.add(paths, 0, value);
        if (key.isWildcard()) {
            this.containsWildCards = true;
        }
        this.addToVanillaDestinations(key, value);
    }

    public synchronized void remove(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            Iterator iter = childDestinations.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                this.remove(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.remove(paths, 0, value);
        this.removeFromVanillaDestinations(key, value);
    }

    protected Set findWildcardMatches(ActiveMQDestination key) {
        Set answer = this.nullAnswer;
        if (!this.containsWildCards && !key.isWildcard()) {
            answer = this.getFromVanillaDestinations(key);
        } else {
            answer = new HashSet();
            String[] paths = key.getDestinationPaths();
            this.rootNode.appendMatchingValues(answer, paths, 0);
        }
        return answer;
    }

    public void removeAll(ActiveMQDestination key) {
        if (key.isComposite()) {
            List childDestinations = key.getChildDestinations();
            Iterator iter = childDestinations.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                this.removeAll(childDestination);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.removeAll(paths, 0);
        this.removeAllFromVanillaDestinations(key);
    }

    private synchronized void addToVanillaDestinations(ActiveMQDestination key, Object value) {
        HashSet<Object> set = new HashSet<Object>();
        Set oldSet = (Set)this.vanillaDestinations.get(key);
        if (oldSet != null) {
            set.addAll(oldSet);
        }
        set.add(value);
        this.vanillaDestinations.put(key, set);
    }

    private synchronized void removeFromVanillaDestinations(ActiveMQDestination key, Object value) {
        Set oldSet = (Set)this.vanillaDestinations.get(key);
        if (oldSet != null) {
            HashSet set = new HashSet(oldSet);
            set.remove(value);
            if (set.isEmpty()) {
                this.vanillaDestinations.remove(key);
            }
            this.vanillaDestinations.put(key, set);
        }
        this.validateContainsWildCards(key);
    }

    private void removeAllFromVanillaDestinations(ActiveMQDestination key) {
        this.vanillaDestinations.remove(key);
        this.validateContainsWildCards(key);
    }

    private Set getFromVanillaDestinations(ActiveMQDestination key) {
        Set answer = (Set)this.vanillaDestinations.get(key);
        return answer != null ? answer : this.nullAnswer;
    }

    private void validateContainsWildCards(ActiveMQDestination key) {
        if (this.containsWildCards && key.isWildcard()) {
            this.containsWildCards = false;
            Iterator i = this.vanillaDestinations.keySet().iterator();
            while (i.hasNext()) {
                ActiveMQDestination dest = (ActiveMQDestination)i.next();
                if (!dest.isWildcard()) continue;
                this.containsWildCards = true;
                break;
            }
        }
    }
}

