/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.impl;

import java.io.File;
import java.io.IOException;
import javax.sql.DataSource;
import org.activemq.message.util.MemoryBoundedObjectManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.PersistenceAdapterFactory;
import org.activemq.store.cache.MemoryBoundedCachePersistenceAdapter;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class DefaultPersistenceAdapterFactory
implements PersistenceAdapterFactory {
    public PersistenceAdapter createPersistenceAdapter(File dataDirectory, MemoryBoundedObjectManager memManager) throws IOException {
        System.setProperty("derby.system.home", dataDirectory.getCanonicalPath());
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDatabaseName("derbydb");
        ds.setCreateDatabase("create");
        JDBCPersistenceAdapter jdbcAdapter = new JDBCPersistenceAdapter();
        jdbcAdapter.setDataSource((DataSource)ds);
        File journalDir = new File(dataDirectory, "journal");
        JournalPersistenceAdapter journalAdapter = new JournalPersistenceAdapter(journalDir, jdbcAdapter);
        journalAdapter.setJournalType("default");
        if (memManager == null) {
            return journalAdapter;
        }
        MemoryBoundedCachePersistenceAdapter cacheAdapter = new MemoryBoundedCachePersistenceAdapter(journalAdapter);
        cacheAdapter.setMemoryManager(memManager);
        return cacheAdapter;
    }
}

