/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.reliable;

import java.net.URI;
import java.util.List;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.TimeoutExpiredException;
import org.codehaus.activemq.UnsupportedWireFormatException;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketListener;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.message.ReceiptHolder;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.composite.CompositeTransportChannel;
import org.codehaus.activemq.transport.reliable.SMLCGRandom;

public class ReliableTransportChannel
extends CompositeTransportChannel
implements PacketListener,
ExceptionListener {
    private static final Log log = LogFactory.getLog((Class)ReliableTransportChannel.class);
    private Object lock = new Object();
    private long keepAliveTimeout = 60000L;

    public ReliableTransportChannel(WireFormat wireFormat) {
        super(wireFormat);
    }

    public ReliableTransportChannel(WireFormat wireFormat, List uris) {
        super(wireFormat, uris);
    }

    public String toString() {
        return "ReliableTransportChannel: " + (this.channel == null ? "No active channel" : this.channel.toString());
    }

    public void setKeepAliveTimeout(long timeoutInterval) {
        this.keepAliveTimeout = timeoutInterval;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Receipt send(Packet packet, int timeout) throws JMSException {
        do {
            TransportChannel tc;
            if ((tc = this.getEstablishedChannel(timeout)) == null) continue;
            try {
                return tc.send(packet, timeout);
            }
            catch (TimeoutExpiredException e) {
                throw e;
            }
            catch (UnsupportedWireFormatException uwf) {
                throw uwf;
            }
            catch (JMSException jmsEx) {
                if (this.isPendingStop()) break;
                this.doReconnect(tc, timeout);
            }
        } while (!this.closed.get() && !this.isPendingStop());
        return null;
    }

    public void asyncSend(Packet packet) throws JMSException {
        long timeout = this.getEstablishConnectionTimeout();
        do {
            TransportChannel tc;
            if ((tc = this.getEstablishedChannel(timeout)) == null) continue;
            try {
                tc.asyncSend(packet);
                break;
            }
            catch (TimeoutExpiredException e) {
                throw e;
            }
            catch (UnsupportedWireFormatException uwf) {
                throw uwf;
            }
            catch (JMSException jmsEx) {
                if (this.isPendingStop()) break;
                this.doReconnect(tc, timeout);
            }
        } while (!this.closed.get() && !this.isPendingStop());
    }

    public ReceiptHolder asyncSendWithReceipt(Packet packet) throws JMSException {
        long timeout = this.getEstablishConnectionTimeout();
        do {
            TransportChannel tc;
            if ((tc = this.getEstablishedChannel(timeout)) == null) continue;
            try {
                return tc.asyncSendWithReceipt(packet);
            }
            catch (TimeoutExpiredException e) {
                throw e;
            }
            catch (UnsupportedWireFormatException uwf) {
                throw uwf;
            }
            catch (JMSException jmsEx) {
                if (this.isPendingStop()) break;
                this.doReconnect(tc, timeout);
            }
        } while (!this.closed.get() && !this.isPendingStop());
        return null;
    }

    protected void configureChannel() {
        this.channel.setPacketListener(this);
        this.channel.setExceptionListener(this);
        this.channel.addTransportStatusEventListener(this);
    }

    protected URI extractURI(List list) throws JMSException {
        Object answer;
        int idx = 0;
        if (list.size() > 1) {
            SMLCGRandom rand = new SMLCGRandom();
            while ((idx = (int)(rand.nextDouble() * (double)list.size())) < 0 || idx >= list.size()) {
            }
        }
        if ((answer = list.remove(idx)) instanceof URI) {
            return (URI)answer;
        }
        log.error((Object)("#### got: " + answer + " of type: " + answer.getClass()));
        return null;
    }

    public void consume(Packet packet) {
        PacketListener listener = this.getPacketListener();
        if (listener != null) {
            listener.consume(packet);
        }
    }

    public void onException(JMSException jmsEx) {
        TransportChannel tc = this.channel;
        if (jmsEx instanceof UnsupportedWireFormatException) {
            this.fireException(jmsEx);
        } else {
            try {
                this.doReconnect(tc, this.getEstablishConnectionTimeout());
            }
            catch (JMSException ex) {
                ex.setLinkedException((Exception)((Object)jmsEx));
                this.fireException(ex);
            }
        }
    }

    public void stop() {
        super.stop();
        this.fireStatusEvent(this.currentURI, 5);
    }

    protected void fireException(JMSException jmsEx) {
        ExceptionListener listener = this.getExceptionListener();
        if (listener != null) {
            listener.onException(jmsEx);
        }
    }

    protected TransportChannel getEstablishedChannel(long timeout) throws JMSException {
        if (!this.closed.get() && this.channel == null && !this.isPendingStop()) {
            this.establishConnection(timeout);
        }
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReconnect(TransportChannel currentChannel, long timeout) throws JMSException {
        this.setTransportConnected(false);
        if (!this.closed.get() && !this.isPendingStop()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.channel == currentChannel) {
                    this.fireStatusEvent(this.currentURI, 2);
                    try {
                        this.establishConnection(timeout);
                    }
                    catch (JMSException jmsEx) {
                        this.fireStatusEvent(this.currentURI, 4);
                        throw jmsEx;
                    }
                    this.setTransportConnected(true);
                    this.fireStatusEvent(this.currentURI, 3);
                }
            }
        }
    }
}

