/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.multicast;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQObjectMessage;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketListener;
import org.codehaus.activemq.transport.DiscoveryAgentSupport;
import org.codehaus.activemq.transport.DiscoveryEvent;
import org.codehaus.activemq.transport.multicast.MulticastTransportChannel;
import org.codehaus.activemq.util.IdGenerator;

public class MulticastDiscoveryAgent
extends DiscoveryAgentSupport
implements PacketListener,
Runnable {
    private static final Log log = LogFactory.getLog((Class)MulticastDiscoveryAgent.class);
    public static final String DEFAULT_DISCOVERY_URI = "multicast://224.1.2.3:6066";
    private static final String KEEP_ALIVE_TYPE = "KEEP_ALIVE";
    private static final String SERVICE_TYPE = "SERVICE";
    private static final String STARTED_TYPE = "STARTED_TYPE";
    private static final String SERVICE_NAME = "SERVICE_NAME";
    private static final String CHANNEL_NAME = "CHANNEL_NAME";
    private static final long DEFAULT_KEEP_ALIVE_TIMEOUT = 5000L;
    private static final int DEFAULT_TIMEOUT_COUNT = 2;
    private ConcurrentHashMap services;
    private ConcurrentHashMap keepAliveMap;
    private SynchronizedBoolean started;
    private MulticastTransportChannel channel;
    private Thread runner;
    private IdGenerator idGen;
    private String localId;
    private URI uri;
    private int timeoutCount;
    private long keepAliveTimeout;
    private long timeoutExpiration;
    private ActiveMQMessage keepAliveMessage;
    private ActiveMQObjectMessage serviceMessage;
    private String serviceName = "";
    private int timeToLive = 1;
    private String channelName;

    public MulticastDiscoveryAgent(String channelName) throws JMSException {
        this.channelName = channelName;
        this.started = new SynchronizedBoolean(false);
        this.services = new ConcurrentHashMap();
        this.keepAliveMap = new ConcurrentHashMap();
        this.idGen = new IdGenerator();
        this.localId = this.idGen.generateId();
        this.keepAliveTimeout = 5000L;
        this.timeoutCount = 2;
        this.timeoutExpiration = this.keepAliveTimeout * (long)this.timeoutCount;
        try {
            this.setUri(new URI(DEFAULT_DISCOVERY_URI));
        }
        catch (URISyntaxException e) {
            JMSException jmsEx = new JMSException("URI Syntax exception: " + e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getTimeoutCount() {
        return this.timeoutCount;
    }

    public void setTimeoutCount(int timeoutCount) {
        this.timeoutCount = timeoutCount;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) throws IOException {
        this.timeToLive = timeToLive;
        if (this.channel != null) {
            this.channel.setTimeToLive(timeToLive);
        }
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String toString() {
        return "MulticastDiscoveryAgent:" + this.serviceName;
    }

    public int getServicesCount() {
        return (this.keepAliveMessage != null ? 1 : 0) + this.services.size();
    }

    public void registerService(String name, Map details) throws JMSException {
        if (this.keepAliveMessage != null) {
            this.keepAliveMessage.setBooleanProperty(STARTED_TYPE, true);
            this.sendKeepAlive();
        }
        this.serviceName = name;
        this.serviceMessage = new ActiveMQObjectMessage();
        this.serviceMessage.setJMSType(SERVICE_TYPE);
        this.serviceMessage.setStringProperty(SERVICE_NAME, name);
        this.serviceMessage.setStringProperty(CHANNEL_NAME, this.channelName);
        this.serviceMessage.setObject((Serializable)((Object)details));
        this.sendService();
        this.keepAliveMessage = new ActiveMQMessage();
        this.keepAliveMessage.setJMSType(KEEP_ALIVE_TYPE);
        this.keepAliveMessage.setStringProperty(SERVICE_NAME, name);
        this.keepAliveMessage.setStringProperty(CHANNEL_NAME, this.channelName);
        this.keepAliveMessage.setBooleanProperty(STARTED_TYPE, true);
        this.sendKeepAlive();
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.timeoutExpiration = this.keepAliveTimeout * (long)this.timeoutCount;
            this.channel = new MulticastTransportChannel((WireFormat)new DefaultWireFormat(), this.uri);
            this.channel.setClientID(this.localId);
            this.channel.setPacketListener(this);
            try {
                this.channel.setTimeToLive(this.getTimeToLive());
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("Set time to live failed");
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            this.channel.start();
            this.runner = new Thread(this);
            this.runner.setName(this.toString());
            this.runner.setDaemon(true);
            this.runner.setPriority(10);
            this.runner.start();
            this.sendService();
            this.sendKeepAlive();
            this.fireServiceStarted(this.serviceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        boolean doStop = false;
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            doStop = this.started.get();
            if (doStop) {
                if (this.keepAliveMessage != null) {
                    this.keepAliveMessage.setBooleanProperty(STARTED_TYPE, false);
                    this.sendKeepAlive();
                }
                this.channel.stop();
                this.started.set(false);
            }
        }
        if (doStop) {
            this.fireServiceStopped(this.serviceMessage);
        }
    }

    public void run() {
        try {
            int count = 0;
            while (this.started.get()) {
                this.sendKeepAlive();
                log.debug((Object)(this.serviceName + " sent keep alive"));
                if (++count >= this.timeoutCount) {
                    count = 0;
                    this.checkNodesAlive();
                }
                Thread.sleep(this.getKeepAliveTimeout());
            }
        }
        catch (Throwable e) {
            log.error((Object)(this.toString() + " run failed"), e);
        }
    }

    public void consume(Packet packet) {
        try {
            if (packet != null && packet.isJMSMessage()) {
                ActiveMQMessage msg = (ActiveMQMessage)packet;
                String receivedChannelName = msg.getStringProperty(CHANNEL_NAME);
                if (receivedChannelName != null && receivedChannelName.equals(this.channelName)) {
                    String type = msg.getJMSType();
                    if (type != null) {
                        if (type.equals(KEEP_ALIVE_TYPE)) {
                            this.processKeepAlive(msg);
                        } else if (type.equals(SERVICE_TYPE)) {
                            this.processService(msg);
                        } else {
                            log.warn((Object)(this.toString() + " received Message of unknown type: " + type));
                        }
                    } else {
                        log.error((Object)(this.toString() + " message type is null"));
                    }
                }
            } else {
                log.warn((Object)(this.toString() + " received unexpected packet: " + packet));
            }
        }
        catch (Throwable e) {
            log.error((Object)(this.toString() + " couldn't process packet: " + packet), e);
        }
    }

    private void sendKeepAlive() throws JMSException {
        if (this.started.get() && this.channel != null && !this.channel.isPendingStop() && this.keepAliveMessage != null) {
            this.channel.asyncSend(this.keepAliveMessage);
        }
    }

    private void sendService() throws JMSException {
        if (this.started.get() && this.channel != null && !this.channel.isPendingStop() && this.serviceMessage != null) {
            this.channel.asyncSend(this.serviceMessage);
        }
    }

    private void processKeepAlive(ActiveMQMessage message) throws JMSException {
        String name = message.getStringProperty(SERVICE_NAME);
        if (message.getBooleanProperty(STARTED_TYPE)) {
            this.addService(name);
        } else {
            this.removeService(name);
        }
    }

    private void processService(ActiveMQMessage message) throws JMSException {
        if (message != null) {
            ActiveMQObjectMessage objMsg = (ActiveMQObjectMessage)message;
            String name = objMsg.getStringProperty(SERVICE_NAME);
            this.addService(name);
            ActiveMQObjectMessage oldMsg = (ActiveMQObjectMessage)this.services.get((Object)name);
            this.services.put((Object)name, (Object)objMsg);
            if (oldMsg == null) {
                this.fireServiceStarted(objMsg);
                this.sendService();
            }
        }
    }

    private void fireServiceStarted(ActiveMQObjectMessage message) throws JMSException {
        if (message != null) {
            String name = message.getStringProperty(SERVICE_NAME);
            Map map = (Map)((Object)message.getObject());
            DiscoveryEvent event = new DiscoveryEvent(this, name, map);
            this.fireAddService(event);
        }
    }

    private void fireServiceStopped(ActiveMQObjectMessage message) throws JMSException {
        if (message != null) {
            String name = message.getStringProperty(SERVICE_NAME);
            Map map = (Map)((Object)message.getObject());
            DiscoveryEvent event = new DiscoveryEvent(this, name, map);
            this.fireRemoveService(event);
        }
    }

    private void addService(String name) {
        long timestamp = System.currentTimeMillis();
        SynchronizedLong activeTime = (SynchronizedLong)this.keepAliveMap.get((Object)name);
        if (activeTime == null) {
            activeTime = new SynchronizedLong(0L);
            this.keepAliveMap.put((Object)name, (Object)activeTime);
        }
        activeTime.set(timestamp);
    }

    private void removeService(String name) throws JMSException {
        this.keepAliveMap.remove((Object)name);
        ActiveMQObjectMessage message = (ActiveMQObjectMessage)this.services.remove((Object)name);
        if (message != null) {
            this.fireServiceStopped(message);
        }
    }

    private void checkNodesAlive() throws JMSException {
        long timestamp = System.currentTimeMillis();
        long timeout = timestamp - this.timeoutExpiration;
        Iterator i = this.keepAliveMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            SynchronizedLong activeTime = (SynchronizedLong)entry.getValue();
            if (activeTime.get() >= timeout) continue;
            String name = entry.getKey().toString();
            this.removeService(name);
            log.warn((Object)(this.serviceName + " Expiring node: " + name));
        }
    }
}

