/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.composite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactorySupport;
import org.codehaus.activemq.transport.composite.CompositeTransportChannel;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class CompositeTransportChannelFactory
extends TransportChannelFactorySupport {
    private String separator = ",";

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            List uris = new ArrayList();
            String text = this.parseURIs(uris, remoteLocation);
            uris = this.randomizeURIs(uris);
            CompositeTransportChannel channel = new CompositeTransportChannel(wireFormat, uris);
            return this.populateProperties((TransportChannel)channel, text);
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException("Can't parse list of URIs for: " + remoteLocation + ". Reason: " + e, e);
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        return this.create(wireFormat, remoteLocation);
    }

    public boolean requiresEmbeddedBroker() {
        return false;
    }

    protected String parseURIs(List uris, URI uri) throws URISyntaxException {
        String answer = "";
        String text = uri.getSchemeSpecificPart();
        if (text.startsWith("(")) {
            int count = 1;
            int size = text.length();
            for (int i = 1; i < size; ++i) {
                char ch = text.charAt(i);
                if (ch == '(') {
                    ++count;
                    continue;
                }
                if (ch != ')' || --count != 0) continue;
                answer = text.substring(i + 1);
                text = text.substring(1, i);
                break;
            }
        }
        StringTokenizer iter = new StringTokenizer(text, this.separator);
        while (iter.hasMoreTokens()) {
            String child = this.stripLeadingSlashes(iter.nextToken().trim());
            uris.add(new URI(child));
        }
        return answer;
    }

    protected String stripLeadingSlashes(String text) {
        int idx;
        for (idx = 0; idx < text.length() && text.charAt(idx) == '/'; ++idx) {
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    protected List randomizeURIs(List uris) {
        return uris;
    }
}

