/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.vm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.util.Map;
import javax.jms.JMSException;
import org.codehaus.activemq.message.ActiveMQQueue;
import org.codehaus.activemq.service.impl.PersistenceAdapterSupport;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.TransactionStore;
import org.codehaus.activemq.store.vm.VMMessageStore;
import org.codehaus.activemq.store.vm.VMTopicMessageStore;
import org.codehaus.activemq.store.vm.VMTransactionStore;

public class VMPersistenceAdapter
extends PersistenceAdapterSupport {
    VMTransactionStore transactionStore = new VMTransactionStore();
    ConcurrentHashMap destinations = new ConcurrentHashMap();

    public Map getInitialDestinations() {
        return this.destinations;
    }

    public static VMPersistenceAdapter newInstance(File file) {
        return new VMPersistenceAdapter();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        ActiveMQQueue dest = new ActiveMQQueue(destinationName);
        MessageStore rc = (MessageStore)this.destinations.get((Object)dest);
        if (rc == null) {
            rc = this.transactionStore.proxy(new VMMessageStore());
            this.destinations.put((Object)dest, (Object)rc);
        }
        return rc;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        ActiveMQQueue dest = new ActiveMQQueue(destinationName);
        TopicMessageStore rc = (TopicMessageStore)this.destinations.get((Object)dest);
        if (rc == null) {
            rc = this.transactionStore.proxy(new VMTopicMessageStore());
            this.destinations.put((Object)dest, (Object)rc);
        }
        return rc;
    }

    public TransactionStore createTransactionStore() throws JMSException {
        return this.transactionStore;
    }

    public void beginTransaction() {
    }

    public void commitTransaction() {
    }

    public void rollbackTransaction() {
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }
}

