/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.TransactionTask;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class AutoCommitTransaction
implements Transaction {
    public static final AutoCommitTransaction AUTO_COMMIT_TRANSACTION = new AutoCommitTransaction();

    private AutoCommitTransaction() {
    }

    public void addPostCommitTask(TransactionTask task) throws JMSException {
        try {
            task.execute();
        }
        catch (Throwable e) {
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            JMSExceptionHelper.newJMSException("Commit task failed: " + e, e);
        }
    }

    public void addPostRollbackTask(TransactionTask task) throws JMSException {
    }

    public void commit(boolean onePhase) throws XAException {
        XAException xae = new XAException("Commit not implemented on Auto Commit Transactions.");
        xae.errorCode = -3;
        throw xae;
    }

    public void rollback() throws XAException {
        XAException xae = new XAException("Rollback not implemented on Auto Commit Transactions.");
        xae.errorCode = -3;
        throw xae;
    }

    public int prepare() throws XAException {
        XAException xae = new XAException("Prepare not implemented on Auto Commit Transactions.");
        xae.errorCode = -3;
        throw xae;
    }

    public boolean isXaTransacted() {
        return false;
    }

    public Object getTransactionId() {
        return null;
    }
}

