/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.TransactionTask;

public abstract class AbstractTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)AbstractTransaction.class);
    public static final byte START_STATE = 0;
    public static final byte IN_USE_STATE = 1;
    public static final byte PREPARED_STATE = 2;
    public static final byte FINISHED_STATE = 3;
    private ArrayList prePrepareTasks = new ArrayList();
    private ArrayList postCommitTasks = new ArrayList();
    private ArrayList postRollbackTasks = new ArrayList();
    private byte state = 0;

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void addPostCommitTask(TransactionTask r) {
        this.postCommitTasks.add(r);
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public void addPostRollbackTask(TransactionTask r) {
        this.postRollbackTasks.add(r);
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public void addPrePrepareTask(TransactionTask r) {
        this.prePrepareTasks.add(r);
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public void prePrepare() throws Throwable {
        switch (this.state) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                XAException xae = new XAException("Prepare cannot be called now.");
                xae.errorCode = -6;
                throw xae;
            }
        }
        Iterator iter = this.prePrepareTasks.iterator();
        while (iter.hasNext()) {
            TransactionTask r = (TransactionTask)iter.next();
            r.execute();
        }
    }

    protected void postCommit() throws Throwable {
        Iterator iter = this.postCommitTasks.iterator();
        while (iter.hasNext()) {
            TransactionTask r = (TransactionTask)iter.next();
            r.execute();
        }
    }

    public void postRollback() throws Throwable {
        Iterator iter = this.postRollbackTasks.iterator();
        while (iter.hasNext()) {
            TransactionTask r = (TransactionTask)iter.next();
            r.execute();
        }
    }

    public String toString() {
        return super.toString() + "[prePrepares=" + this.prePrepareTasks + "; postCommits=" + this.postCommitTasks + "; postRollbacks=" + this.postRollbackTasks + "]";
    }
}

