/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.impl.AutoCommitTransaction;

public abstract class TransactionManager
implements Service {
    private static final ThreadLocal contextTx = new ThreadLocal();

    public static void setContexTransaction(Transaction tx) {
        contextTx.set(tx);
    }

    public static Transaction getContexTransaction() {
        Transaction tx = (Transaction)contextTx.get();
        if (tx == null) {
            return AutoCommitTransaction.AUTO_COMMIT_TRANSACTION;
        }
        return tx;
    }

    public static boolean isCurrentTransaction() {
        return contextTx.get() != null;
    }

    public abstract Transaction createLocalTransaction(BrokerClient var1, String var2) throws JMSException;

    public abstract Transaction getLocalTransaction(String var1) throws JMSException;

    public abstract Transaction createXATransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public abstract Transaction getXATransaction(ActiveMQXid var1) throws XAException;

    public abstract ActiveMQXid[] getPreparedXATransactions() throws XAException;

    public abstract void cleanUpClient(BrokerClient var1) throws JMSException;

    public abstract void recover(Transaction var1);
}

