/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.security.jassjacc;

import java.io.Serializable;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractJMSPermission
extends Permission
implements Serializable {
    private String action;
    private int cachedHashCode;
    private HashSet actions;

    public AbstractJMSPermission(String name, String action) {
        super(name);
        String[] listOfActions = AbstractJMSPermission.normalize(action);
        this.actions = new HashSet<String>(Arrays.asList(listOfActions));
        if (!this.getValidSetOfActions().containsAll(this.actions)) {
            throw new IllegalArgumentException("The action set (" + this.actions + ") is invalid. Valid set of actions are: " + this.getValidSetOfActions());
        }
        this.action = AbstractJMSPermission.join(listOfActions);
    }

    public abstract Set getValidSetOfActions();

    private static String[] normalize(String action) {
        Object[] strings = action.split(",", -1);
        Arrays.sort(strings);
        return strings;
    }

    private static String join(String[] action) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < action.length; ++i) {
            if (i != 0) {
                buff.append(",");
            }
            buff.append(action[i]);
        }
        return buff.toString();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.getName().hashCode() ^ this.action.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractJMSPermission)) {
            return false;
        }
        AbstractJMSPermission other = (AbstractJMSPermission)o;
        return this.getName().equals(other.getName()) && this.action.equals(other.action);
    }

    public String getActions() {
        return this.action;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof AbstractJMSPermission)) {
            return false;
        }
        AbstractJMSPermission other = (AbstractJMSPermission)permission;
        return this.getName().equals(other.getName()) && other.actions.containsAll(this.actions);
    }
}

