/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message.util;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.util.BoundedActiveMQMessageQueue;
import org.codehaus.activemq.message.util.MemoryBoundedQueueManager;
import org.codehaus.activemq.service.QueueListEntry;
import org.codehaus.activemq.service.impl.DefaultQueueList;

public class MemoryBoundedQueue
implements BoundedActiveMQMessageQueue {
    private static final int WAIT_TIMEOUT = 100;
    private MemoryBoundedQueueManager queueManager;
    private String name;
    private boolean stopped = false;
    private boolean closed = false;
    private long memoryUsedByThisQueue;
    private Object outLock = new Object();
    private Object inLock = new Object();
    private DefaultQueueList internalList = new DefaultQueueList();

    MemoryBoundedQueue(String name, MemoryBoundedQueueManager manager) {
        this.name = name;
        this.queueManager = manager;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "" + this.name + " , cardinality = " + this.size() + " memory usage = " + this.memoryUsedByThisQueue + " , contents{" + this.internalList + "}";
    }

    public int size() {
        return this.internalList.size();
    }

    public long getLocalMemoryUsedByThisQueue() {
        return this.memoryUsedByThisQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.clear();
            this.closed = true;
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notifyAll();
            }
            object = this.inLock;
            synchronized (object) {
                this.inLock.notifyAll();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.queueManager.removeMemoryBoundedQueue(this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueNoBlock(ActiveMQMessage packet) {
        if (!this.closed) {
            this.internalList.add(packet);
            this.incrementMemoryUsed(packet);
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(ActiveMQMessage packet) {
        if (!this.queueManager.isFull()) {
            this.enqueueNoBlock(packet);
        } else {
            Object object = this.inLock;
            synchronized (object) {
                try {
                    while (this.queueManager.isFull() && !this.closed) {
                        this.inLock.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.enqueueNoBlock(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueFirstNoBlock(ActiveMQMessage packet) {
        if (!this.closed) {
            this.internalList.addFirst(packet);
            this.incrementMemoryUsed(packet);
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFirst(ActiveMQMessage packet) throws InterruptedException {
        if (!this.queueManager.isFull()) {
            this.enqueueFirstNoBlock(packet);
        } else {
            Object object = this.inLock;
            synchronized (object) {
                while (this.queueManager.isFull() && !this.closed) {
                    this.inLock.wait(100L);
                }
            }
            this.enqueueFirstNoBlock(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage dequeue() throws InterruptedException {
        ActiveMQMessage result = null;
        Object object = this.outLock;
        synchronized (object) {
            while (this.internalList.isEmpty() && !this.closed) {
                this.outLock.wait(100L);
            }
            result = this.dequeueNoWait();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage dequeue(long timeInMillis) throws InterruptedException {
        ActiveMQMessage result = null;
        if (timeInMillis == 0L) {
            result = this.dequeue();
        } else {
            Object object = this.outLock;
            synchronized (object) {
                long start;
                long waitTime = timeInMillis;
                long l = start = timeInMillis <= 0L ? 0L : System.currentTimeMillis();
                while (!this.closed && (result = this.dequeueNoWait()) == null && waitTime > 0L) {
                    this.outLock.wait(waitTime);
                    waitTime = timeInMillis - (System.currentTimeMillis() - start);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage dequeueNoWait() throws InterruptedException {
        ActiveMQMessage packet = null;
        Object object = this.outLock;
        synchronized (object) {
            while (this.stopped && !this.closed) {
                this.outLock.wait(100L);
            }
        }
        packet = (ActiveMQMessage)this.internalList.removeFirst();
        this.decrementMemoryUsed(packet);
        if (packet != null) {
            object = this.inLock;
            synchronized (object) {
                this.inLock.notify();
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.outLock;
        synchronized (object) {
            return !this.stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.outLock;
        synchronized (object) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.outLock;
        synchronized (object) {
            this.stopped = false;
            this.outLock.notifyAll();
        }
        object = this.inLock;
        synchronized (object) {
            this.inLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ActiveMQMessage packet) {
        boolean result = false;
        if (!this.internalList.isEmpty()) {
            result = this.internalList.remove(packet);
        }
        if (result) {
            this.decrementMemoryUsed(packet);
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notify();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage remove(String id) {
        ActiveMQMessage result = null;
        QueueListEntry entry = this.internalList.getFirstEntry();
        try {
            while (entry != null) {
                ActiveMQMessage p = (ActiveMQMessage)entry.getElement();
                if (p.getJMSMessageID().equals(id)) {
                    result = p;
                    this.remove(p);
                    break;
                }
                entry = this.internalList.getNextEntry(entry);
            }
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notify();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        while (!this.internalList.isEmpty()) {
            ActiveMQMessage packet = (ActiveMQMessage)this.internalList.removeFirst();
            this.decrementMemoryUsed(packet);
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notifyAll();
        }
    }

    public boolean isEmpty() {
        return this.internalList.isEmpty();
    }

    public ActiveMQMessage get(int index) {
        return (ActiveMQMessage)this.internalList.get(index);
    }

    public List getContents() {
        Object[] array = this.internalList.toArray();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    private synchronized void incrementMemoryUsed(ActiveMQMessage packet) {
        if (packet != null) {
            this.memoryUsedByThisQueue += (long)this.queueManager.incrementMemoryUsed(packet);
        }
    }

    private synchronized void decrementMemoryUsed(ActiveMQMessage packet) {
        if (packet != null) {
            this.memoryUsedByThisQueue -= (long)this.queueManager.decrementMemoryUsed(packet);
        }
    }
}

