/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.advisories.TempDestinationAdvisoryEvent;
import org.codehaus.activemq.advisories.TempDestinationAdvisoryEventListener;
import org.codehaus.activemq.message.ActiveMQDestination;

public class TempDestinationAdvisor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)TempDestinationAdvisor.class);
    private Connection connection;
    private ActiveMQDestination destination;
    private Session session;
    private List listeners = new CopyOnWriteArrayList();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);

    public TempDestinationAdvisor(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = ActiveMQDestination.transformDestination(destination);
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.session = this.connection.createSession(false, 1);
            String name = "";
            String advisoryName = "ActiveMQ.Advisory.TempDestinations." + this.destination.getPhysicalName();
            ActiveMQDestination advisoryDestination = ActiveMQDestination.createDestination(this.destination.getDestinationType(), advisoryName);
            MessageConsumer consumer = this.session.createConsumer((Destination)advisoryDestination);
            consumer.setMessageListener((MessageListener)this);
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void addListener(TempDestinationAdvisoryEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TempDestinationAdvisoryEventListener l) {
        this.listeners.remove(l);
    }

    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            try {
                TempDestinationAdvisoryEvent event = (TempDestinationAdvisoryEvent)((ObjectMessage)msg).getObject();
                this.fireEvent(event);
            }
            catch (JMSException e) {
                log.error((Object)("Failed to process message: " + msg));
            }
        }
    }

    private void fireEvent(TempDestinationAdvisoryEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TempDestinationAdvisoryEventListener l = (TempDestinationAdvisoryEventListener)i.next();
            l.onEvent(event);
        }
    }
}

