/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.impl.BrokerConnectorImpl;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.BrokerInfo;
import org.codehaus.activemq.transport.NetworkChannel;
import org.codehaus.activemq.transport.NetworkConnector;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelProvider;
import org.codehaus.activemq.transport.TransportStatusEvent;
import org.codehaus.activemq.transport.TransportStatusEventListener;
import org.codehaus.activemq.transport.composite.CompositeTransportChannel;

public class RemoteNetworkChannel
extends NetworkChannel
implements TransportStatusEventListener {
    private static final Log log = LogFactory.getLog((Class)RemoteNetworkChannel.class);
    private TransportChannel boondocksChannel;

    public RemoteNetworkChannel(PooledExecutor tp) {
        super(tp);
    }

    public RemoteNetworkChannel(NetworkConnector connector, BrokerContainer brokerContainer, String uri) {
        super(connector, brokerContainer, uri);
    }

    public void statusChanged(TransportStatusEvent event) {
        if (event.getTransportChannel() == this.boondocksChannel) {
            if (event.getChannelStatus() == 3) {
                try {
                    this.sendBrokerInfo();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to send Broker Info", (Throwable)e);
                }
            }
        } else {
            super.statusChanged(event);
        }
    }

    protected void initialize() throws JMSException {
        super.initialize();
        try {
            this.boondocksChannel = TransportChannelProvider.create(new DefaultWireFormat(), new URI(this.uri));
            this.boondocksChannel.addTransportStatusEventListener(this);
            if (this.boondocksChannel instanceof CompositeTransportChannel) {
                CompositeTransportChannel composite = (CompositeTransportChannel)this.boondocksChannel;
                composite.setMaximumRetries(this.maximumRetries);
                composite.setFailureSleepTime(this.reconnectSleepTime);
                composite.setIncrementTimeout(false);
            }
            this.boondocksChannel.start();
            BrokerConnectorImpl connector = new BrokerConnectorImpl(this.getBrokerContainer(), "vm://uri", new DefaultWireFormat());
            connector.start();
            connector.addClient(this.boondocksChannel);
            this.sendBrokerInfo();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Could not parse uri: " + this.uri + " to make remote connector"), (Throwable)e);
        }
    }

    private void sendBrokerInfo() throws JMSException {
        BrokerInfo info = new BrokerInfo();
        info.setBrokerName(this.brokerContainer.getBroker().getBrokerName());
        info.setClusterName(this.brokerContainer.getBroker().getBrokerClusterName());
        info.setRemote(true);
        this.boondocksChannel.asyncSend(info);
    }
}

