/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.vm;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.store.MessageStore;

public class VMMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)VMMessageStore.class);
    protected Map messageTable;

    public VMMessageStore() {
        this(new LinkedHashMap());
    }

    public VMMessageStore(LinkedHashMap messageTable) {
        this.messageTable = Collections.synchronizedMap(messageTable);
    }

    public void addMessage(ActiveMQMessage message) throws JMSException {
        this.messageTable.put(message.getJMSMessageID(), message);
        message.getJMSMessageIdentity();
    }

    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        String messageID = identity.getMessageID();
        return (ActiveMQMessage)this.messageTable.get(messageID);
    }

    public void removeMessage(MessageAck ack) throws JMSException {
        this.messageTable.remove(ack.getMessageID());
    }

    public void removeMessage(MessageIdentity msgId) throws JMSException {
        this.messageTable.remove(msgId.getMessageID());
    }

    public void recover(QueueMessageContainer container) throws JMSException {
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
        this.messageTable.clear();
    }

    public void removeAllMessages() throws JMSException {
        this.messageTable.clear();
    }
}

