/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.util.BoundedActiveMQMessageQueue;
import org.codehaus.activemq.message.util.DataContainer;

public class SpooledBoundedActiveMQMessageQueue
implements BoundedActiveMQMessageQueue {
    private String name;
    private DataContainer container;
    private WireFormat wireFormat;
    private long maxDataLength;
    private boolean closed;
    private boolean stopped;
    private SynchronizedInt size = new SynchronizedInt(0);
    private Object inLock = new Object();
    private Object outLock = new Object();
    private static int WAIT_TIMEOUT = 250;
    private static final Log log = LogFactory.getLog((Class)SpooledBoundedActiveMQMessageQueue.class);

    public SpooledBoundedActiveMQMessageQueue(File dir, String name, long maxDataLength, int maxBlockSize) throws IOException {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i])) continue;
            chars[i] = 95;
        }
        this.name = new String(chars);
        this.maxDataLength = maxDataLength;
        this.wireFormat = new DefaultWireFormat();
        this.container = new DataContainer(dir, this.name, maxBlockSize);
        this.container.deleteAll();
    }

    public SpooledBoundedActiveMQMessageQueue(File dir, String name) throws IOException {
        this(dir, name, 0x4000000L, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(ActiveMQMessage packet) throws JMSException {
        if (!this.isFull()) {
            this.enqueueNoBlock(packet);
        } else {
            Object object = this.inLock;
            synchronized (object) {
                try {
                    while (this.isFull()) {
                        this.inLock.wait(WAIT_TIMEOUT);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.enqueueNoBlock(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueNoBlock(ActiveMQMessage packet) throws JMSException {
        try {
            byte[] data = this.wireFormat.toBytes(packet);
            this.size.increment();
            this.container.write(data);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("enqueNoBlock failed: " + e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        Object object = this.outLock;
        synchronized (object) {
            this.outLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage dequeue() throws JMSException, InterruptedException {
        ActiveMQMessage result = null;
        Object object = this.outLock;
        synchronized (object) {
            while ((result = this.dequeueNoWait()) == null) {
                this.outLock.wait(WAIT_TIMEOUT);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage dequeue(long timeInMillis) throws JMSException, InterruptedException {
        ActiveMQMessage result = this.dequeueNoWait();
        if (result == null) {
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.wait(timeInMillis);
                result = this.dequeueNoWait();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage dequeueNoWait() throws JMSException, InterruptedException {
        ActiveMQMessage result = null;
        if (this.stopped) {
            Object object = this.outLock;
            synchronized (object) {
                while (this.stopped && !this.closed) {
                    this.outLock.wait(WAIT_TIMEOUT);
                }
            }
        }
        try {
            byte[] data = this.container.read();
            if (data != null) {
                result = (ActiveMQMessage)this.wireFormat.fromBytes(data);
                this.size.decrement();
            }
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("fromBytes failed");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        if (result != null && !this.isFull()) {
            Object object = this.inLock;
            synchronized (object) {
                this.inLock.notify();
            }
        }
        return result;
    }

    public boolean isFull() {
        return this.container.length() >= this.maxDataLength;
    }

    public void close() {
        try {
            this.closed = true;
            this.container.close();
        }
        catch (IOException ioe) {
            log.warn((Object)"Couldn't close queue", (Throwable)ioe);
        }
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.size.get();
    }

    public boolean isStarted() {
        return !this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.outLock;
        synchronized (object) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.stopped = false;
        Object object = this.outLock;
        synchronized (object) {
            this.outLock.notifyAll();
        }
        object = this.inLock;
        synchronized (object) {
            this.inLock.notifyAll();
        }
    }

    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void clear() {
    }

    public List getContents() {
        return null;
    }
}

