/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.util.SerializationHelper;

public class ActiveMQObjectMessage
extends ActiveMQMessage
implements ObjectMessage {
    private Serializable object;

    public int getPacketType() {
        return 8;
    }

    public ActiveMQMessage shallowCopy() throws JMSException {
        ActiveMQObjectMessage other = new ActiveMQObjectMessage();
        this.initializeOther(other);
        other.object = this.object;
        return other;
    }

    public ActiveMQMessage deepCopy() throws JMSException {
        return this.shallowCopy();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.object = null;
    }

    public void setObject(Serializable newObject) throws JMSException {
        if (this.readOnlyMessage) {
            throw new MessageNotWriteableException("The message is read-only");
        }
        try {
            this.setBodyAsBytes(null);
            this.object = newObject;
            this.getBodyAsBytes();
        }
        catch (IOException e) {
            throw (MessageFormatException)new MessageFormatException("Could not serialize the object: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    void setObjectPayload(Object newObject) {
        this.object = (Serializable)newObject;
    }

    public Serializable getObject() throws JMSException {
        if (this.object == null) {
            try {
                super.buildBodyFromBytes();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("failed to build body from bytes");
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
        }
        return this.object;
    }

    public void prepareMessageBody() throws JMSException {
        try {
            this.convertBodyToBytes();
            this.object = null;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("failed to convert body to bytes");
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBody(DataOutput dataOut) throws IOException {
        SerializationHelper.writeObject((OutputStream)((Object)dataOut), this.object);
    }

    public void readBody(DataInput dataIn) throws IOException {
        try {
            this.object = (Serializable)SerializationHelper.readObject((InputStream)((Object)dataIn));
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public String toString() {
        Object object = null;
        try {
            object = this.getObject();
        }
        catch (JMSException e) {
            object = e;
        }
        return super.toString() + " ActiveMQObjectMessage{ " + "object = " + object + " }";
    }
}

