/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import org.codehaus.activemq.io.impl.AbstractPacketReader;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.WireFormatInfo;

public class WireFormatInfoReader
extends AbstractPacketReader {
    DefaultWireFormat wireFormat;

    WireFormatInfoReader() {
    }

    WireFormatInfoReader(DefaultWireFormat format) {
        this.wireFormat = format;
    }

    public int getPacketType() {
        return 29;
    }

    public Packet createPacket() {
        return new WireFormatInfo();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        for (int i = 0; i < WireFormatInfo.MAGIC.length; ++i) {
            if (dataIn.readByte() == WireFormatInfo.MAGIC[i]) continue;
            throw new IOException("Invalid WireFormatInfo packet.");
        }
        super.buildPacket(packet, dataIn);
        WireFormatInfo info = (WireFormatInfo)packet;
        info.setVersion(dataIn.readInt());
        if (this.wireFormat != null) {
            this.wireFormat.setCurrentWireFormatVersion(info.getVersion());
        }
    }
}

