/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQObjectMessage;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.util.IdGenerator;

class AdvisorySupport {
    private static final Log log = LogFactory.getLog((Class)AdvisorySupport.class);
    private Map advisoryConsumers = new ConcurrentHashMap();
    private List consumers = new CopyOnWriteArrayList();
    private List producers = new CopyOnWriteArrayList();
    private List connections = new CopyOnWriteArrayList();
    private IdGenerator idGen = new IdGenerator();

    AdvisorySupport() {
    }

    boolean addAdvisory(ConsumerInfo advisory, BrokerClient client) {
        boolean result;
        boolean bl = result = advisory != null && advisory.isAdvisory() && client != null;
        if (result) {
            AbstractPacket info;
            this.advisoryConsumers.put(advisory, client);
            Iterator i = this.consumers.iterator();
            while (i.hasNext()) {
                info = (ConsumerInfo)i.next();
                this.generateAdvisory(advisory, (ConsumerInfo)info);
            }
            i = this.producers.iterator();
            while (i.hasNext()) {
                info = (ProducerInfo)i.next();
                this.generateAdvisory(advisory, (ProducerInfo)info);
            }
            i = this.connections.iterator();
            while (i.hasNext()) {
                info = (ConnectionInfo)i.next();
                this.generateAdvisory(advisory, (ConnectionInfo)info);
            }
        }
        return result;
    }

    boolean removeAdvisory(ConsumerInfo info, BrokerClient client) {
        return this.advisoryConsumers.remove(info) != null;
    }

    void addConsumer(ConsumerInfo info) {
        this.consumers.add(info);
        Iterator i = this.advisoryConsumers.keySet().iterator();
        while (i.hasNext()) {
            ConsumerInfo advisory = (ConsumerInfo)i.next();
            this.generateAdvisory(advisory, info);
        }
    }

    void removeConsumer(ConsumerInfo info) {
        this.consumers.remove(info);
        Iterator i = this.advisoryConsumers.keySet().iterator();
        while (i.hasNext()) {
            ConsumerInfo advisory = (ConsumerInfo)i.next();
            this.generateAdvisory(advisory, info);
        }
    }

    void addProducer(ProducerInfo info) {
        this.producers.add(info);
        Iterator i = this.advisoryConsumers.keySet().iterator();
        while (i.hasNext()) {
            ConsumerInfo advisory = (ConsumerInfo)i.next();
            this.generateAdvisory(advisory, info);
        }
    }

    void removeProducer(ProducerInfo info) {
        this.producers.remove(info);
        Iterator i = this.advisoryConsumers.keySet().iterator();
        while (i.hasNext()) {
            ConsumerInfo advisory = (ConsumerInfo)i.next();
            this.generateAdvisory(advisory, info);
        }
    }

    void addConnection(ConnectionInfo info) {
        this.connections.add(info);
        Iterator i = this.advisoryConsumers.keySet().iterator();
        while (i.hasNext()) {
            ConsumerInfo advisory = (ConsumerInfo)i.next();
            this.generateAdvisory(advisory, info);
        }
    }

    void removeConnection(ConnectionInfo info) {
        this.connections.remove(info);
        Iterator i = this.advisoryConsumers.keySet().iterator();
        while (i.hasNext()) {
            ConsumerInfo advisory = (ConsumerInfo)i.next();
            this.generateAdvisory(advisory, info);
        }
    }

    private void generateAdvisory(ConsumerInfo advisory, ConsumerInfo info) {
        if (this.matchConsumer(advisory, info)) {
            BrokerClient client = (BrokerClient)this.advisoryConsumers.get(advisory);
            String suffix = info.isStarted() ? "started" : "stopped";
            String destName = "ActiveMQ.Advisory.Consumers." + info.getDestination() + suffix;
            ActiveMQDestination dest = ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), destName);
            this.generateAdvisoryMessage(advisory, client, info, dest);
        }
    }

    private void generateAdvisory(ConsumerInfo advisory, ProducerInfo info) {
        if (this.matchProducer(advisory, info)) {
            BrokerClient client = (BrokerClient)this.advisoryConsumers.get(advisory);
            String suffix = info.isStarted() ? "started" : "stopped";
            String destName = "ActiveMQ.Advisory.Consumers." + info.getDestination() + suffix;
            ActiveMQDestination dest = ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), destName);
            this.generateAdvisoryMessage(advisory, client, info, dest);
        }
    }

    private void generateAdvisory(ConsumerInfo advisory, ConnectionInfo info) {
        if (this.matchConnection(advisory, info)) {
            BrokerClient client = (BrokerClient)this.advisoryConsumers.get(advisory);
            String suffix = info.isStarted() ? "started" : "stopped";
            String destName = advisory.getDestination().getPhysicalName() + suffix;
            ActiveMQDestination dest = ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), destName);
            this.generateAdvisoryMessage(advisory, client, info, dest);
        }
    }

    boolean matchConsumer(ConsumerInfo advisory, ConsumerInfo info) {
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && info != null && info.getDestination() != null) {
            ActiveMQDestination advisoryDestination = advisory.getDestination();
            ActiveMQDestination destination = info.getDestination();
            if (advisoryDestination.isConsumerAdvisory()) {
                String pyhsicalName = advisory.getDestination().getPhysicalName();
                String matchName = pyhsicalName.substring("ActiveMQ.Advisory.Consumers.".length(), pyhsicalName.length());
                ActiveMQDestination match = ActiveMQDestination.createDestination(advisoryDestination.getDestinationType(), matchName);
                return match.matches(destination) || this.matchGeneralAdvisory(advisory, destination);
            }
        }
        return result;
    }

    boolean matchProducer(ConsumerInfo advisory, ProducerInfo info) {
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && info != null && info.getDestination() != null) {
            ActiveMQDestination advisoryDestination = advisory.getDestination();
            ActiveMQDestination destination = info.getDestination();
            if (advisoryDestination.isProducerAdvisory()) {
                String pyhsicalName = advisory.getDestination().getPhysicalName();
                String matchName = pyhsicalName.substring("ActiveMQ.Advisory.Producers.".length(), pyhsicalName.length());
                ActiveMQDestination match = ActiveMQDestination.createDestination(advisoryDestination.getDestinationType(), matchName);
                return match.matches(destination) || this.matchGeneralAdvisory(advisory, destination);
            }
        }
        return result;
    }

    boolean matchConnection(ConsumerInfo advisory, ConnectionInfo info) {
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && info != null) {
            result = advisory.getDestination().isConnectionAdvisory() || advisory.getDestination().matches(ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), "ActiveMQ.Advisory.Connections."));
        }
        return result;
    }

    boolean matchGeneralAdvisory(ConsumerInfo advisory, ActiveMQDestination destination) {
        boolean result;
        boolean bl = result = advisory.getDestination() != null && advisory.getDestination().isAdvisory();
        if (result) {
            String pyhsicalName = advisory.getDestination().getPhysicalName();
            String matchName = pyhsicalName.substring("ActiveMQ.Advisory.".length(), pyhsicalName.length());
            ActiveMQDestination match = ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), matchName);
            result = match.matches(destination);
        }
        return result;
    }

    private void generateAdvisoryMessage(ConsumerInfo advisoryTarget, BrokerClient targetClient, Packet payload, ActiveMQDestination destination) {
        ActiveMQObjectMessage advisoryMsg = new ActiveMQObjectMessage();
        advisoryMsg.setJMSMessageID(this.idGen.generateId());
        advisoryMsg.setJMSDestination(destination);
        advisoryMsg.setExternalMessageId(true);
        advisoryMsg.setDeliveryCount(1);
        try {
            advisoryMsg.setObject((Serializable)((Object)payload));
        }
        catch (JMSException e) {
            log.warn((Object)"caught an exception generating an advisory", (Throwable)e);
        }
        advisoryMsg.setConsumerNos(new int[]{advisoryTarget.getConsumerNo()});
        targetClient.dispatch(advisoryMsg);
    }
}

