/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.advisories.ConnectionAdvisoryEvent;
import org.codehaus.activemq.advisories.ConnectionAdvisoryEventListener;
import org.codehaus.activemq.message.ActiveMQTopic;
import org.codehaus.activemq.message.ConnectionInfo;

public class ConnectionAdvisor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)ConnectionAdvisor.class);
    private Connection connection;
    private Session session;
    private List listeners = new CopyOnWriteArrayList();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);

    public ConnectionAdvisor(Connection connection) throws JMSException {
        this.connection = connection;
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.session = this.connection.createSession(false, 1);
            String advisoryName = "ActiveMQ.Advisory.Connections.";
            ActiveMQTopic advisoryDestination = new ActiveMQTopic(advisoryName);
            MessageConsumer consumer = this.session.createConsumer((Destination)advisoryDestination);
            consumer.setMessageListener((MessageListener)this);
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void addListener(ConnectionAdvisoryEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ConnectionAdvisoryEventListener l) {
        this.listeners.remove(l);
    }

    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            try {
                ConnectionInfo info = (ConnectionInfo)((ObjectMessage)msg).getObject();
                ConnectionAdvisoryEvent event = new ConnectionAdvisoryEvent(info);
                this.fireEvent(event);
            }
            catch (JMSException e) {
                log.error((Object)("Failed to process message: " + msg));
            }
        }
    }

    private void fireEvent(ConnectionAdvisoryEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConnectionAdvisoryEventListener l = (ConnectionAdvisoryEventListener)i.next();
            l.onEvent(event);
        }
    }
}

