/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class URIHelper {
    private StringTokenizer tokenizer;

    public static Map parseQuery(URI uri) {
        return URIHelper.parseQuery(URIHelper.getLastQuery(uri));
    }

    public static Map parseQuery(String query) {
        HashMap answer = new HashMap();
        if (query != null) {
            StringTokenizer iter = new StringTokenizer(query, "&");
            while (iter.hasMoreTokens()) {
                String pair = iter.nextToken();
                URIHelper.addKeyValuePair(answer, pair);
            }
        }
        return answer;
    }

    public static String getLastQuery(URI uri) {
        int index;
        String uriString;
        String result = null;
        if (uri != null && (uriString = uri.toString()) != null && (index = uri.toString().lastIndexOf(63)) >= 0 && index + 1 < uriString.length()) {
            result = uriString.substring(index + 1);
        }
        return result;
    }

    protected static void addKeyValuePair(Map answer, String pair) {
        int idx = pair.indexOf(61);
        String name = null;
        String value = null;
        if (idx >= 0) {
            name = pair.substring(0, idx);
            if (++idx < pair.length()) {
                value = pair.substring(idx);
            }
        } else {
            name = pair;
        }
        answer.put(name, value);
    }

    public URIHelper(String path) {
        if (path != null) {
            this.tokenizer = new StringTokenizer(this.strip(path), ",");
        }
    }

    public boolean hasNext() {
        return this.tokenizer == null ? false : this.tokenizer.hasMoreTokens();
    }

    public String getNext() {
        return this.tokenizer == null ? null : this.tokenizer.nextToken();
    }

    private String strip(String str) {
        int index;
        String result = null;
        if (str != null && (index = (result = str.trim()).indexOf(40)) >= 0 && index + 1 < result.length()) {
            result = result.substring(index + 1);
            index = result.lastIndexOf(41);
            result = result.substring(0, index);
        }
        return result;
    }
}

