/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.reliable;

public class SMLCGRandom {
    private static final long MULTIPLIER_1 = 40014L;
    private static final long MOD_1 = 2147483563L;
    private static final long MULTIPLIER_2 = 40692L;
    private static final long MOD_2 = 0x7FFFFF07L;
    private static final int SHUFFLE_LEN = 32;
    private static final int WARMUP_LENGTH = 19;
    private int generated_1;
    private int generated_2;
    private int state;
    private int[] shuffle = new int[32];

    public SMLCGRandom() {
        this(System.currentTimeMillis());
    }

    public SMLCGRandom(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) throws IllegalArgumentException {
        int i;
        this.generated_1 = this.generated_2 = (int)(seed & 0x7FFFFFFFFL);
        for (i = 0; i < 19; ++i) {
            this.generated_1 = (int)((long)this.generated_1 * 40014L % 2147483563L);
        }
        for (i = 0; i < 32; ++i) {
            this.shuffle[31 - i] = this.generated_1 = (int)((long)this.generated_1 * 40014L % 2147483563L);
        }
        this.state = this.shuffle[0];
    }

    public short nextShort() {
        return (short)((short)this.nextByte() << 8 | (short)(this.nextByte() & 0xFF));
    }

    public int nextInt() {
        return this.nextShort() << 16 | this.nextShort() & 0xFFFF;
    }

    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    public float nextFloat() {
        return (float)((double)(this.nextInt() & Integer.MAX_VALUE) / 2.147483647E9);
    }

    public double nextDouble() {
        return (double)(this.nextLong() & Long.MAX_VALUE) / 9.223372036854776E18;
    }

    public byte nextByte() {
        int i = 0;
        this.generated_1 = (int)((long)this.generated_1 * 40014L % 2147483563L);
        this.generated_2 = (int)((long)this.generated_2 * 40692L % 0x7FFFFF07L);
        i = this.state / 0x3FFFFFE;
        i = Math.abs(i);
        this.state = (int)(((long)this.shuffle[i] + (long)this.generated_2) % 2147483563L);
        this.shuffle[i] = this.generated_1;
        return (byte)(this.state / 0x800000);
    }
}

