/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import org.codehaus.activemq.filter.DestinationFilter;
import org.codehaus.activemq.message.ActiveMQDestination;

public class CompositeDestinationFilter
extends DestinationFilter {
    private List filters;

    public CompositeDestinationFilter(ActiveMQDestination destination) {
        List childDestinations = destination.getChildDestinations();
        this.filters = new ArrayList(childDestinations.size());
        Iterator iter = childDestinations.iterator();
        while (iter.hasNext()) {
            Destination childDestination = (Destination)iter.next();
            this.filters.add(DestinationFilter.parseFilter(childDestination));
        }
    }

    public boolean matches(Destination destination) {
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            DestinationFilter filter = (DestinationFilter)iter.next();
            if (!filter.matches(destination)) continue;
            return true;
        }
        return false;
    }

    public boolean isWildcard() {
        return true;
    }
}

