/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.impl.AbstractTransaction;
import org.codehaus.activemq.service.impl.TransactionManagerImpl;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.util.SerializationHelper;

public class XATransactionCommand
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerImpl.class);
    private ActiveMQXid xid;
    private transient Map xaTxs;
    private transient PreparedTransactionStore preparedTransactions;

    public XATransactionCommand() {
        super(null);
    }

    public XATransactionCommand(Broker broker, ActiveMQXid xid, Map xaTxs, PreparedTransactionStore preparedTransactions) {
        super(broker);
        this.xid = xid;
        this.xaTxs = xaTxs;
        this.preparedTransactions = preparedTransactions;
    }

    public void initialise(Map xaTxs, PreparedTransactionStore preparedTransactions) {
        this.xaTxs = xaTxs;
        this.preparedTransactions = preparedTransactions;
    }

    public void commit(boolean onePhase) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XA Transaction commit: " + this.xid));
        }
        switch (this.getState()) {
            case 0: {
                this.checkForPreparedState(onePhase);
                this.setStateFinished();
                break;
            }
            case 1: {
                this.checkForPreparedState(onePhase);
                this.doPrePrepare();
                this.setStateFinished();
                this.doPostCommit();
                break;
            }
            case 2: {
                this.setStateFinished();
                this.doPostCommit();
                break;
            }
            default: {
                this.illegalStateTransition("commit");
            }
        }
    }

    private void illegalStateTransition(String callName) throws XAException {
        XAException xae = new XAException("Cannot call " + callName + " now.");
        xae.errorCode = -6;
        throw xae;
    }

    private void checkForPreparedState(boolean onePhase) throws XAException {
        if (!onePhase) {
            XAException xae = new XAException("Cannot do 2 phase commit if the transaction has not been prepared.");
            xae.errorCode = -6;
            throw xae;
        }
    }

    private void doPrePrepare() throws XAException {
        try {
            this.prePrepare();
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warn((Object)"PRE-PREPARE FAILED: ", e);
            this.rollback();
            XAException xae = new XAException("PRE-PREPARE FAILED: Transaction rolled back.");
            xae.errorCode = 104;
            xae.initCause(e);
            throw xae;
        }
    }

    private void doPostCommit() throws XAException {
        try {
            this.postCommit();
        }
        catch (Throwable e) {
            log.warn((Object)"POST COMMIT FAILED: ", e);
            XAException xae = new XAException("POST COMMIT FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public void rollback() throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XA Transaction rollback: " + this.xid));
        }
        switch (this.getState()) {
            case 0: {
                this.setStateFinished();
                break;
            }
            case 1: {
                this.setStateFinished();
                this.doPostRollback();
                break;
            }
            case 2: {
                this.preparedTransactions.remove(this.xid);
                this.setStateFinished();
                this.doPostRollback();
            }
        }
    }

    private void doPostRollback() throws XAException {
        try {
            this.postRollback();
        }
        catch (Throwable e) {
            log.warn((Object)"POST ROLLBACK FAILED: ", e);
            XAException xae = new XAException("POST ROLLBACK FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public int prepare() throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XA Transaction prepare: " + this.xid));
        }
        switch (this.getState()) {
            case 0: {
                this.setStateFinished();
                return 3;
            }
            case 1: {
                this.doPrePrepare();
                this.setState((byte)2);
                this.preparedTransactions.put(this.xid, this);
                return 0;
            }
        }
        this.illegalStateTransition("prepare");
        return 3;
    }

    private void setStateFinished() {
        this.setState((byte)3);
        this.xaTxs.remove(this.xid);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.xid = ActiveMQXid.read(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.xid.writeExternal(out);
    }

    public static Transaction fromBytes(byte[] data) throws IOException, ClassNotFoundException {
        return (Transaction)SerializationHelper.deserialize(data);
    }

    public byte[] toBytes() throws IOException {
        return SerializationHelper.serialize(this);
    }
}

