/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.util;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemProperties {
    private static final Log log = LogFactory.getLog((Class)SystemProperties.class);
    private static final boolean canAccessSystemProperties;
    private static final Properties defaultProperties;

    public static Properties getSystemProperties() {
        return canAccessSystemProperties ? System.getProperties() : defaultProperties;
    }

    public static String getUserName() {
        return canAccessSystemProperties ? System.getProperty("user.name") : "defaultUser";
    }

    static {
        defaultProperties = new Properties();
        SecurityManager securityManager = System.getSecurityManager();
        boolean haveAccess = false;
        if (securityManager != null) {
            try {
                securityManager.checkPropertiesAccess();
                haveAccess = true;
            }
            catch (Throwable e) {
                haveAccess = false;
                log.warn((Object)"Do not have access to System properties", e);
            }
        }
        canAccessSystemProperties = haveAccess;
    }
}

