/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.transport.NetworkChannel;
import org.codehaus.activemq.transport.TransportChannelListener;

public class NetworkConnector
implements Service {
    private static final Log log = LogFactory.getLog((Class)NetworkConnector.class);
    private BrokerContainer brokerContainer;
    private TransportChannelListener transportChannelListener;
    private List networkChannels = new ArrayList();
    private Map localDetails = new HashMap();
    private String remoteUserName;
    private String remotePassword;
    protected PooledExecutor threadPool;

    public NetworkConnector(BrokerContainer brokerContainer) {
        this.brokerContainer = brokerContainer;
        this.threadPool = new PooledExecutor();
    }

    public void start() throws JMSException {
        Iterator iter = this.networkChannels.iterator();
        while (iter.hasNext()) {
            NetworkChannel networkChannel = (NetworkChannel)iter.next();
            networkChannel.setBrokerContainer(this.getBrokerContainer());
            networkChannel.setThreadPool(this.threadPool);
            networkChannel.start();
        }
    }

    public void stop() throws JMSException {
        Iterator iter = this.networkChannels.iterator();
        while (iter.hasNext()) {
            NetworkChannel networkChannel = (NetworkChannel)iter.next();
            try {
                networkChannel.stop();
            }
            catch (JMSException e) {
                log.warn((Object)("Failed to stop network channel: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void setTransportChannelListener(TransportChannelListener listener) {
        this.transportChannelListener = listener;
    }

    public BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public PooledExecutor getThreadPool() {
        return this.threadPool;
    }

    public List getNetworkChannels() {
        return this.networkChannels;
    }

    public Map getLocalDetails() {
        return this.localDetails;
    }

    public void setLocalDetails(Map localDetails) {
        this.localDetails = localDetails;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    public void setNetworkChannels(List networkChannels) {
        this.networkChannels = networkChannels;
    }

    public NetworkChannel addNetworkChannel(String uri) {
        NetworkChannel networkChannel = this.createNetworkChannel(uri);
        this.addNetworkChannel(networkChannel);
        return networkChannel;
    }

    public void addNetworkChannel(NetworkChannel networkChannel) {
        this.networkChannels.add(networkChannel);
    }

    public void removeNetworkChannel(NetworkChannel networkChannel) {
        this.networkChannels.remove(networkChannel);
    }

    protected NetworkChannel createNetworkChannel(String url) {
        NetworkChannel answer = new NetworkChannel(this, this.getBrokerContainer(), url);
        answer.setRemoteUserName(this.getRemoteUserName());
        answer.setRemotePassword(this.getRemotePassword());
        return answer;
    }
}

