/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;

public abstract class AbstractWireFormat
implements WireFormat {
    private static final Log log = LogFactory.getLog((Class)WireFormat.class);

    public Packet readPacket(String channelID, DatagramPacket dpacket) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(dpacket.getData(), dpacket.getOffset(), dpacket.getLength()));
        String id = in.readUTF();
        if (channelID == null) {
            log.trace((Object)"We do not have a channelID which is probably caused by a synchronization issue, we're receiving messages before we're fully initialised");
        } else if (channelID.equals(id)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Discarding packet from id: " + id));
            }
            return null;
        }
        byte type = in.readByte();
        Packet packet = this.readPacket(type, in);
        return packet;
    }

    public DatagramPacket writePacket(String channelID, Packet packet) throws IOException, JMSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        channelID = channelID != null ? channelID : "";
        dataOut.writeUTF(channelID);
        this.writePacket(packet, dataOut);
        dataOut.close();
        byte[] data = out.toByteArray();
        return new DatagramPacket(data, data.length);
    }

    public Packet fromBytes(byte[] bytes, int offset, int length) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes, offset, length));
        return this.readPacket(in);
    }

    public Packet fromBytes(byte[] bytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        return this.readPacket(in);
    }

    public byte[] toBytes(Packet packet) throws IOException, JMSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        this.writePacket(packet, dataOut);
        dataOut.close();
        return out.toByteArray();
    }

    public void initiateProtocol(DataOutput dataOut) throws IOException, JMSException {
    }
}

