/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.codehaus.activemq.ActiveMQXAConnection;
import org.codehaus.activemq.ActiveMQXASession;
import org.codehaus.activemq.Closeable;

public class ActiveMQRASession
extends ActiveMQXASession
implements Closeable {
    private boolean inLocalTransaction;
    private boolean inXATransaction;
    private boolean autoCommit = false;

    public ActiveMQRASession(ActiveMQXAConnection theConnection, int theAcknowlegeMode) throws JMSException {
        super(theConnection, theAcknowlegeMode);
    }

    public boolean getTransacted() throws JMSException {
        return this.inLocalTransaction || this.inXATransaction || !this.autoCommit;
    }

    protected boolean isXaTransacted() {
        return this.inXATransaction;
    }

    protected void doStartTransaction() throws JMSException {
        if (!(this.inXATransaction || this.inLocalTransaction || this.autoCommit)) {
            this.begin();
        }
    }

    public void begin() throws JMSException {
        if (this.inXATransaction) {
            throw new TransactionInProgressException("Cannot start local transction.  XA transaction is allready in progress.");
        }
        if (this.inLocalTransaction) {
            throw new TransactionInProgressException("Cannot start local transction.  Local transaction is allready in progress.");
        }
        this.inLocalTransaction = true;
        this.startLocalTransaction();
    }

    public boolean isInLocalTransaction() {
        return this.inLocalTransaction;
    }

    public void rollback() throws JMSException {
        if (this.inXATransaction) {
            throw new TransactionInProgressException("Cannot rollback() if an XA transaction is allready in progress ");
        }
        if (this.autoCommit) {
            throw new IllegalStateException("Not a transacted session");
        }
        if (!this.autoCommit && !this.inLocalTransaction) {
            return;
        }
        if (!this.inLocalTransaction) {
            throw new JMSException("Cannot rollback local transction.  Local transaction had not been started.");
        }
        this.inLocalTransaction = false;
        this.rollbackLocalTransaction();
    }

    public void commit() throws JMSException {
        if (this.inXATransaction) {
            throw new TransactionInProgressException("Cannot commit() if an XA transaction is allready in progress ");
        }
        if (this.autoCommit) {
            throw new IllegalStateException("Not a transacted session");
        }
        if (!this.autoCommit && !this.inLocalTransaction) {
            return;
        }
        if (!this.inLocalTransaction) {
            throw new IllegalStateException("Cannot commit local transction.  Local transaction had not been started.");
        }
        this.inLocalTransaction = false;
        this.commitLocalTransaction();
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.inLocalTransaction) {
            throw new XAException(-6);
        }
        super.start(xid, flags);
        this.inXATransaction = true;
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.inLocalTransaction) {
            throw new XAException(-6);
        }
        super.end(xid, flags);
        this.inXATransaction = false;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setAcknowlegeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }
}

