/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import org.codehaus.activemq.io.impl.AbstractPacketWriter;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.util.BitArray;

public class ActiveMQMessageWriter
extends AbstractPacketWriter {
    public int getPacketType() {
        return 6;
    }

    public void writePacket(Packet packet, DataOutput dataOut) throws IOException {
        ActiveMQMessage msg = (ActiveMQMessage)packet;
        byte[] payload = msg.getBodyAsBytes();
        BitArray ba = msg.getBitArray();
        ba.reset();
        this.writeUTF(msg.getId(), dataOut);
        ba.set(0, packet.isReceiptRequired());
        Object[] visited = msg.getBrokersVisited();
        boolean writeVisited = visited != null && visited.length > 0;
        ba.set(1, writeVisited);
        ba.set(2, msg.getJMSCorrelationID() != null);
        ba.set(3, msg.getJMSType() != null);
        ba.set(4, msg.getEntryBrokerName() != null);
        ba.set(5, msg.getEntryClusterName() != null);
        ba.set(6, msg.getTransactionId() != null);
        ba.set(7, msg.getJMSReplyTo() != null);
        ba.set(8, msg.getJMSTimestamp() > 0L);
        ba.set(9, msg.getJMSExpiration() > 0L);
        ba.set(10, msg.getJMSRedelivered());
        ba.set(11, msg.isXaTransacted());
        ba.set(12, msg.getConsumerNos() != null);
        ba.set(13, msg.getProperties() != null && msg.getProperties().size() > 0);
        ba.set(14, msg.isDispatchedFromDLQ());
        ba.set(15, payload != null);
        ba.writeToStream(dataOut);
        if (writeVisited) {
            dataOut.writeShort(visited.length);
            for (int i = 0; i < visited.length; ++i) {
                dataOut.writeUTF(visited[i].toString());
            }
        }
        super.writeUTF(msg.getJMSClientID(), dataOut);
        super.writeUTF(msg.getProducerID(), dataOut);
        ActiveMQDestination.writeToStream((ActiveMQDestination)msg.getJMSDestination(), dataOut);
        dataOut.write(msg.getJMSDeliveryMode());
        dataOut.write(msg.getJMSPriority());
        if (ba.get(2)) {
            super.writeUTF(msg.getJMSCorrelationID(), dataOut);
        }
        if (ba.get(3)) {
            super.writeUTF(msg.getJMSType(), dataOut);
        }
        if (ba.get(4)) {
            super.writeUTF(msg.getEntryBrokerName(), dataOut);
        }
        if (ba.get(5)) {
            super.writeUTF(msg.getEntryClusterName(), dataOut);
        }
        if (ba.get(6)) {
            super.writeUTF(msg.getTransactionId(), dataOut);
        }
        if (ba.get(7)) {
            ActiveMQDestination.writeToStream((ActiveMQDestination)msg.getJMSReplyTo(), dataOut);
        }
        if (ba.get(8)) {
            dataOut.writeLong(msg.getJMSTimestamp());
        }
        if (ba.get(9)) {
            dataOut.writeLong(msg.getJMSExpiration());
        }
        if (ba.get(12)) {
            int[] cids = msg.getConsumerNos();
            dataOut.writeShort(cids.length);
            for (int i = 0; i < cids.length; ++i) {
                dataOut.writeShort(cids[i]);
            }
        }
        if (ba.get(13)) {
            msg.writeMapProperties(msg.getProperties(), dataOut);
        }
        if (ba.get(15)) {
            dataOut.writeInt(payload.length);
            dataOut.write(payload);
        }
        if (this.wireFormatVersion >= 2) {
            dataOut.writeLong(msg.getSequenceNumber());
            dataOut.writeByte(msg.getDeliveryCount());
        }
    }
}

