/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.composite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import org.codehaus.activemq.message.WireFormat;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactory;
import org.codehaus.activemq.transport.composite.CompositeTransportChannel;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class CompositeTransportChannelFactory
implements TransportChannelFactory {
    private String separator = ",";

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            return new CompositeTransportChannel(wireFormat, this.parseURIs(remoteLocation));
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException("Can't parse list of URIs for: " + remoteLocation + ". Reason: " + e, e);
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        return this.create(wireFormat, remoteLocation);
    }

    public boolean requiresEmbeddedBroker() {
        return false;
    }

    protected List parseURIs(URI uri) throws URISyntaxException {
        String text = uri.getSchemeSpecificPart();
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer iter = new StringTokenizer(text, this.separator);
        while (iter.hasMoreTokens()) {
            String child = this.stripLeadingSlashes(iter.nextToken().trim());
            uris.add(new URI(child));
        }
        return this.randomizeURIs(uris);
    }

    protected String stripLeadingSlashes(String text) {
        int idx = 0;
        while (text.charAt(idx) == '/') {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    protected List randomizeURIs(List uris) {
        return uris;
    }
}

