/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.UnsupportedWireFormatException;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketListener;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.message.ReceiptHolder;
import org.codehaus.activemq.message.WireFormatInfo;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelListener;
import org.codehaus.activemq.transport.TransportStatusEvent;
import org.codehaus.activemq.transport.TransportStatusEventListener;
import org.codehaus.activemq.util.ExecutorHelper;

public abstract class TransportChannelSupport
implements TransportChannel {
    private static final Log log = LogFactory.getLog((Class)TransportChannelSupport.class);
    private CopyOnWriteArrayList listeners = new CopyOnWriteArrayList();
    private HashMap requestMap = new HashMap();
    private PacketListener packetListener;
    private ExceptionListener exceptionListener;
    private String clientID;
    private TransportChannelListener transportChannelListener;
    private boolean serverSide;
    protected boolean pendingStop = false;
    protected boolean transportConnected = true;

    public void setPendingStop(boolean pendingStop) {
        this.pendingStop = pendingStop;
    }

    public boolean isPendingStop() {
        return this.pendingStop;
    }

    public void stop() {
        this.transportConnected = false;
        Map map = (Map)this.requestMap.clone();
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            ReceiptHolder rh = (ReceiptHolder)i.next();
            rh.close();
        }
        map.clear();
        this.requestMap.clear();
        if (this.transportChannelListener != null) {
            this.transportChannelListener.removeClient(this);
        }
        this.exceptionListener = null;
        this.packetListener = null;
    }

    public Receipt send(Packet packet) throws JMSException {
        return this.send(packet, 0);
    }

    public Receipt send(Packet packet, int timeout) throws JMSException {
        ReceiptHolder rh = new ReceiptHolder();
        this.requestMap.put(packet.getId(), rh);
        this.doAsyncSend(packet);
        Receipt result = rh.getReceipt(timeout);
        return result;
    }

    public TransportChannelListener getTransportChannelListener() {
        return this.transportChannelListener;
    }

    public void setTransportChannelListener(TransportChannelListener transportChannelListener) {
        this.transportChannelListener = transportChannelListener;
    }

    public void addTransportStatusEventListener(TransportStatusEventListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeTransportStatusEventListener(TransportStatusEventListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public PacketListener getPacketListener() {
        return this.packetListener;
    }

    public void setPacketListener(PacketListener l) {
        this.packetListener = l;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public boolean isTransportConnected() {
        return this.transportConnected;
    }

    protected void setTransportConnected(boolean value) {
        this.transportConnected = value;
    }

    protected void doConsumePacket(Packet packet) {
        this.doConsumePacket(packet, this.packetListener);
    }

    protected void doConsumePacket(Packet packet, PacketListener listener) {
        if (!this.doHandleReceipt(packet) && !this.doHandleWireFormat(packet)) {
            if (listener != null) {
                listener.consume(packet);
            } else {
                log.warn((Object)"No packet listener set to receive packets");
            }
        }
    }

    protected boolean doHandleReceipt(Packet packet) {
        boolean result = false;
        if (packet != null && packet.isReceipt()) {
            result = true;
            Receipt receipt = (Receipt)packet;
            ReceiptHolder rh = (ReceiptHolder)this.requestMap.remove(receipt.getCorrelationId());
            if (rh != null) {
                rh.setReceipt(receipt);
            } else {
                log.warn((Object)("No Packet found to match Receipt correlationId: " + receipt.getCorrelationId()));
            }
        }
        return result;
    }

    protected boolean doHandleWireFormat(Packet packet) {
        boolean handled = false;
        if (packet.getPacketType() == 29) {
            handled = true;
            WireFormatInfo info = (WireFormatInfo)packet;
            if (!this.canProcessWireFormatVersion(info.getVersion())) {
                this.setPendingStop(true);
                String errorStr = "Cannot process wire format of version: " + info.getVersion();
                TransportStatusEvent event = new TransportStatusEvent();
                event.setChannelStatus(4);
                this.fireStatusEvent(event);
                this.onAsyncException(new UnsupportedWireFormatException(errorStr));
                this.stop();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(this + " using wire format version: " + info.getVersion()));
            }
        }
        return handled;
    }

    protected void doAsyncSend(Packet packet) throws JMSException {
        this.asyncSend(packet);
    }

    protected void onAsyncException(JMSException e) {
        if (this.exceptionListener != null) {
            this.transportConnected = false;
            this.exceptionListener.onException(e);
        } else {
            log.warn((Object)("Caught exception dispatching message and no ExceptionListener registered: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    protected void fireStatusEvent(URI remoteURI, int status) {
        TransportStatusEvent event = new TransportStatusEvent();
        event.setChannelStatus(status);
        event.setRemoteURI(remoteURI);
        this.fireStatusEvent(event);
    }

    protected void fireStatusEvent(TransportStatusEvent event) {
        if (event != null) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                TransportStatusEventListener l = (TransportStatusEventListener)i.next();
                l.statusChanged(event);
            }
        }
    }

    protected void stopExecutor(Executor executor) throws InterruptedException, JMSException {
        ExecutorHelper.stopExecutor(executor);
    }
}

