/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQMessageProducer;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.service.Service;

class NetworkMessageBridge
implements Service,
MessageListener {
    private String localBrokerName;
    private ActiveMQMessageProducer localProducer;
    private MessageConsumer remoteConsumer;
    private Session localSession;
    private Session remoteSession;
    private boolean stopped;
    private boolean durableTopic;
    private ActiveMQDestination destination;
    private SynchronizedInt referenceCount = new SynchronizedInt(0);
    private static final Log log = LogFactory.getLog((Class)NetworkMessageBridge.class);

    public void setDurableTopic(boolean durableTopic) {
        this.durableTopic = durableTopic;
    }

    public boolean isDurableTopic() {
        return this.durableTopic;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public String getLocalBrokerName() {
        return this.localBrokerName;
    }

    public void setLocalBrokerName(String localBrokerName) {
        this.localBrokerName = localBrokerName;
    }

    public Session getLocalSession() {
        return this.localSession;
    }

    public void setLocalSession(Session localSession) {
        this.localSession = localSession;
    }

    public Session getRemoteSession() {
        return this.remoteSession;
    }

    public void setRemoteSession(Session remoteSession) {
        this.remoteSession = remoteSession;
    }

    public int incrementReferenceCount() {
        return this.referenceCount.increment();
    }

    public int decrementReferenceCount() {
        return this.referenceCount.decrement();
    }

    public void start() throws JMSException {
        this.localProducer = (ActiveMQMessageProducer)this.localSession.createProducer((Destination)this.destination);
        this.localProducer.setReuseMessageId(true);
        if (this.isDurableTopic()) {
            String subsName = this.destination.toString() + "@" + this.localBrokerName;
            this.remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.destination, subsName);
        } else {
            this.remoteConsumer = this.remoteSession.createConsumer((Destination)this.destination);
        }
        this.remoteConsumer.setMessageListener((MessageListener)this);
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.referenceCount.set(0);
            try {
                this.localSession.close();
                this.remoteSession.close();
            }
            catch (JMSException jmsEx) {
                log.warn((Object)"failure in stopping the message bridge", (Throwable)jmsEx);
            }
        }
    }

    public void onMessage(Message msg) {
        try {
            ActiveMQMessage message;
            if (!this.stopped && (message = (ActiveMQMessage)msg) != null) {
                message = message.shallowCopy();
                message.addBrokerVisited(this.localBrokerName);
                Destination destination = message.getJMSDestination();
                int deliveryMode = message.getJMSDeliveryMode();
                int priority = message.getJMSPriority();
                long timeToLive = message.getJMSExpiration() - msg.getJMSTimestamp();
                this.localProducer.send(destination, message, deliveryMode, priority, timeToLive);
                msg.acknowledge();
            }
        }
        catch (JMSException jmsEx) {
            log.error((Object)"NetworkMessageConsumer failed", (Throwable)jmsEx);
            this.stop();
        }
    }

    public int hashCode() {
        return this.destination.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NetworkMessageBridge) {
            NetworkMessageBridge other = (NetworkMessageBridge)obj;
            result = this.destination.equals(other.destination) && this.isDurableTopic() == other.isDurableTopic();
        }
        return result;
    }
}

