/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.transport.NetworkChannel;
import org.codehaus.activemq.transport.TransportChannelListener;

public class NetworkConnector
implements Service {
    private static final Log log = LogFactory.getLog((Class)NetworkConnector.class);
    private BrokerContainer brokerContainer;
    private TransportChannelListener transportChannelListener;
    private List networkChannels = new ArrayList();

    public NetworkConnector(BrokerContainer brokerContainer) {
        this.brokerContainer = brokerContainer;
    }

    public void start() throws JMSException {
        Iterator iter = this.networkChannels.iterator();
        while (iter.hasNext()) {
            NetworkChannel networkChannel = (NetworkChannel)iter.next();
            networkChannel.setBrokerContainer(this.getBrokerContainer());
            networkChannel.start();
        }
    }

    public void stop() throws JMSException {
        Iterator iter = this.networkChannels.iterator();
        while (iter.hasNext()) {
            NetworkChannel networkChannel = (NetworkChannel)iter.next();
            try {
                networkChannel.stop();
            }
            catch (JMSException e) {
                log.warn((Object)("Failed to stop network channel: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void setTransportChannelListener(TransportChannelListener listener) {
        this.transportChannelListener = listener;
    }

    public BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public List getNetworkChannels() {
        return this.networkChannels;
    }

    public void setNetworkChannels(List networkChannels) {
        this.networkChannels = networkChannels;
    }

    public NetworkChannel addNetworkChannel(String uri) {
        NetworkChannel networkChannel = new NetworkChannel(this.brokerContainer, uri);
        this.addNetworkChannel(networkChannel);
        return networkChannel;
    }

    public void addNetworkChannel(NetworkChannel networkChannel) {
        this.networkChannels.add(networkChannel);
    }

    public void removeNetworkChannel(NetworkChannel networkChannel) {
        this.networkChannels.remove(networkChannel);
    }
}

