/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ConfigurationException;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.transport.DiscoveryAgent;
import org.codehaus.activemq.transport.DiscoveryEvent;
import org.codehaus.activemq.transport.DiscoveryListener;
import org.codehaus.activemq.transport.NetworkChannel;
import org.codehaus.activemq.transport.NetworkConnector;
import org.codehaus.activemq.util.MapHelper;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Log log = LogFactory.getLog((Class)DiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private Map localDetails = new HashMap();
    private Map channelMap = new HashMap();
    private String remoteUserName;
    private String remotePassword;

    public DiscoveryNetworkConnector(BrokerContainer brokerContainer) {
        super(brokerContainer);
    }

    public void start() throws JMSException {
        DiscoveryAgent discoveryAgent = this.getBrokerContainer().getDiscoveryAgent();
        if (discoveryAgent == null) {
            throw new ConfigurationException("Must be configured with a discoveryAgent property");
        }
        discoveryAgent.addDiscoveryListener(this);
        super.start();
    }

    public void addService(DiscoveryEvent event) {
        try {
            String url;
            Map details = event.getServiceDetails();
            if (!this.getLocalBrokerName().equals(details.get("brokerName")) && (url = MapHelper.getString(details, "connectURL")) != null) {
                this.addChannel(url, details);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Add service failed", (Throwable)e);
        }
    }

    public void removeService(DiscoveryEvent event) {
        try {
            String url;
            Map details = event.getServiceDetails();
            if (!this.getLocalBrokerName().equals(details.get("brokerName")) && (url = MapHelper.getString(details, "connectURL")) != null) {
                this.removeChannel(url, details);
            }
        }
        catch (Exception e) {
            log.warn((Object)"remove service failed", (Throwable)e);
        }
    }

    public Map getLocalDetails() {
        return this.localDetails;
    }

    public void setLocalDetails(Map localDetails) {
        this.localDetails = localDetails;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    protected synchronized void addChannel(String url, Map details) {
        NetworkChannel channel = (NetworkChannel)this.channelMap.get(url);
        if (channel == null) {
            channel = this.createNetworkChannel(url, details);
            channel.setUri(url);
            log.info((Object)(this.getLocalBrokerName() + ": Adding new NeworkChannel on: " + url + " with details: " + details));
            try {
                channel.start();
                this.channelMap.put(url, channel);
            }
            catch (JMSException e) {
                log.warn((Object)(this.getLocalBrokerName() + ": Could not start channel: " + channel + ". Reason: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected synchronized void removeChannel(String url, Map details) {
        NetworkChannel channel = (NetworkChannel)this.channelMap.remove(url);
        if (channel != null) {
            log.info((Object)(this.getLocalBrokerName() + ": Removing NeworkChannel: " + channel));
            try {
                channel.stop();
            }
            catch (JMSException e) {
                log.info((Object)("Failed to stop channel: " + channel + ". Reason: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected NetworkChannel createNetworkChannel(String url, Map details) {
        NetworkChannel answer = new NetworkChannel(this.getBrokerContainer(), url);
        answer.setRemoteUserName(this.getRemoteUserName());
        answer.setRemotePassword(this.getRemotePassword());
        return answer;
    }

    protected String getLocalBrokerName() {
        return this.getBrokerContainer().getBroker().getBrokerName();
    }
}

