/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.service.Dispatcher;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageContainerManager;
import org.codehaus.activemq.service.Subscription;

public abstract class MessageContainerManagerSupport
implements MessageContainerManager {
    protected Dispatcher dispatcher;
    protected Map messageContainers = new ConcurrentHashMap();
    private Map destinations = new ConcurrentHashMap();
    private boolean maintainDestinationStats = true;

    public MessageContainerManagerSupport(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        dispatcher.register(this);
    }

    public Map getDestinations() {
        return Collections.unmodifiableMap(this.destinations);
    }

    public void start() throws JMSException {
        this.dispatcher.start();
    }

    public void stop() throws JMSException {
        this.dispatcher.stop();
        JMSException firstException = null;
        try {
            this.dispatcher.stop();
        }
        catch (JMSException e) {
            firstException = e;
        }
        Iterator iter = this.messageContainers.values().iterator();
        while (iter.hasNext()) {
            MessageContainer container = (MessageContainer)iter.next();
            try {
                container.stop();
            }
            catch (JMSException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public synchronized MessageContainer getContainer(String destinationName) throws JMSException {
        MessageContainer container = (MessageContainer)this.messageContainers.get(destinationName);
        if (container == null) {
            container = this.createContainer(destinationName);
            container.start();
            this.messageContainers.put(destinationName, container);
            this.destinations.put(destinationName, this.createDestination(destinationName));
        }
        return container;
    }

    public boolean isMaintainDestinationStats() {
        return this.maintainDestinationStats;
    }

    public void setMaintainDestinationStats(boolean maintainDestinationStats) {
        this.maintainDestinationStats = maintainDestinationStats;
    }

    protected abstract Destination createDestination(String var1);

    protected abstract MessageContainer createContainer(String var1) throws JMSException;

    protected void loadContainer(String destinationName, Destination destination) throws JMSException {
        this.destinations.put(destinationName, destination);
        MessageContainer container = this.createContainer(destinationName);
        container.start();
        this.messageContainers.put(destinationName, container);
    }

    protected void updateAcknowledgeStats(BrokerClient client, Subscription subscription) {
        if (this.isMaintainDestinationStats()) {
            String name = subscription.getDestination().getPhysicalName();
            ActiveMQDestination destination = (ActiveMQDestination)this.destinations.get(name);
            destination.getStats().onMessageAck();
        }
    }

    protected void updateSendStats(BrokerClient client, ActiveMQMessage message) throws JMSException {
        String name;
        ActiveMQDestination destination;
        if (this.isMaintainDestinationStats() && (destination = (ActiveMQDestination)this.destinations.get(name = message.getJMSActiveMQDestination().getPhysicalName())) != null) {
            destination.getStats().onMessageSend(message);
        }
    }
}

