/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.DataInput;
import java.io.IOException;
import org.codehaus.activemq.message.AbstractPacketReader;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.ProducerInfo;

public class ProducerInfoReader
extends AbstractPacketReader {
    public int getPacketType() {
        return 18;
    }

    public Packet createPacket() {
        return new ProducerInfo();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        super.buildPacket(packet, dataIn);
        ProducerInfo info = (ProducerInfo)packet;
        info.setProducerId(dataIn.readUTF());
        info.setClientId(dataIn.readUTF());
        info.setSessionId(dataIn.readUTF());
        info.setStartTime(dataIn.readLong());
        info.setStarted(dataIn.readBoolean());
        info.setDestination(ActiveMQDestination.readFromStream(dataIn));
    }
}

