/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.DataInput;
import java.io.IOException;
import org.codehaus.activemq.message.AbstractPacketReader;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.Packet;

public class ConsumerInfoReader
extends AbstractPacketReader {
    public int getPacketType() {
        return 17;
    }

    public Packet createPacket() {
        return new ConsumerInfo();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        super.buildPacket(packet, dataIn);
        ConsumerInfo info = (ConsumerInfo)packet;
        info.setConsumerId(dataIn.readUTF());
        info.setClientId(dataIn.readUTF());
        info.setSessionId(dataIn.readUTF());
        info.setSelector(dataIn.readUTF());
        info.setConsumerName(dataIn.readUTF());
        info.setConsumerNo(dataIn.readInt());
        info.setPrefetchNumber(dataIn.readShort());
        info.setStartTime(dataIn.readLong());
        info.setStarted(dataIn.readBoolean());
        info.setReceiptRequired(dataIn.readBoolean());
        info.setNoLocal(dataIn.readBoolean());
        info.setBrowser(dataIn.readBoolean());
        info.setDestination(ActiveMQDestination.readFromStream(dataIn));
    }
}

