/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketWriter;
import org.codehaus.activemq.util.BitArray;

public abstract class AbstractPacketWriter
implements PacketWriter {
    protected void writeUTF(String str, DataOutput dataOut) throws IOException {
        if (str == null) {
            str = "";
        }
        dataOut.writeUTF(str);
    }

    public boolean canWrite(Packet packet) {
        return packet.getPacketType() == this.getPacketType();
    }

    protected void writeObject(Object object, DataOutput dataOut) throws IOException {
        if (object != null) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
            objOut.writeObject(object);
            objOut.flush();
            byte[] data = bytesOut.toByteArray();
            dataOut.writeInt(data.length);
            dataOut.write(data);
        } else {
            dataOut.writeInt(0);
        }
    }

    public byte[] writePacketToByteArray(Packet packet) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.writePacket(packet, dataOut);
        dataOut.flush();
        return bytesOut.toByteArray();
    }

    public void writePacket(Packet p, DataOutput dataOut) throws IOException {
        AbstractPacket packet = (AbstractPacket)p;
        this.writeUTF(packet.getId(), dataOut);
        BitArray ba = packet.getBitArray();
        ba.set(0, packet.isReceiptRequired());
        Object[] visited = packet.getBrokersVisited();
        boolean writeVisited = visited != null && visited.length > 0;
        ba.set(1, writeVisited);
        ba.writeToStream(dataOut);
        if (writeVisited) {
            dataOut.writeShort(visited.length);
            for (int i = 0; i < visited.length; ++i) {
                dataOut.writeUTF(visited[i].toString());
            }
        }
    }
}

