/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketReader;
import org.codehaus.activemq.util.BitArray;

public abstract class AbstractPacketReader
implements PacketReader {
    public boolean canRead(int packetType) {
        return this.getPacketType() == packetType;
    }

    protected String readUTF(DataInput dataIn) throws IOException {
        return dataIn.readUTF();
    }

    protected Object readObject(DataInput dataIn) throws IOException {
        int dataLength = dataIn.readInt();
        if (dataLength > 0) {
            byte[] data = new byte[dataLength];
            dataIn.readFully(data);
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
            ObjectInputStream objIn = new ObjectInputStream(bytesIn);
            try {
                return objIn.readObject();
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        return null;
    }

    public void buildPacket(Packet p, DataInput dataIn) throws IOException {
        AbstractPacket packet = (AbstractPacket)p;
        packet.setId(this.readUTF(dataIn));
        BitArray ba = packet.getBitArray();
        ba.readFromStream(dataIn);
        packet.setReceiptRequired(ba.get(0));
        if (ba.get(1)) {
            int visitedLen = dataIn.readShort();
            for (int i = 0; i < visitedLen; ++i) {
                packet.addBrokerVisited(dataIn.readUTF());
            }
        }
    }

    public Packet readPacketFromByteArray(byte[] data) throws IOException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
        DataInputStream dataIn = new DataInputStream(bytesIn);
        Packet packet = this.createPacket();
        this.buildPacket(packet, dataIn);
        return packet;
    }
}

