/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.util.BitArray;

public abstract class AbstractPacket
implements Packet {
    static final int RECEIPT_REQUIRED_INDEX = 0;
    static final int BROKERS_VISITED_INDEX = 1;
    private String id;
    protected BitArray bitArray = new BitArray();
    private boolean receiptRequired;
    private transient int memoryUsage = 2048;
    private transient int memoryUsageReferenceCount;
    private CopyOnWriteArraySet brokersVisited;

    protected AbstractPacket() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public boolean isReceiptRequired() {
        return this.receiptRequired;
    }

    public boolean isReceipt() {
        return false;
    }

    public void setReceiptRequired(boolean value) {
        this.receiptRequired = value;
    }

    public boolean isJMSMessage() {
        return false;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof AbstractPacket) {
            AbstractPacket other = (AbstractPacket)obj;
            result = other.getId().equals(this.getId());
        }
        return result;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(int newMemoryUsage) {
        this.memoryUsage = newMemoryUsage;
    }

    public synchronized int incrementMemoryReferenceCount() {
        return ++this.memoryUsageReferenceCount;
    }

    public synchronized int decrementMemoryReferenceCount() {
        return --this.memoryUsageReferenceCount;
    }

    public synchronized int getMemoryUsageReferenceCount() {
        return this.memoryUsageReferenceCount;
    }

    public void addBrokerVisited(String brokerName) {
        this.initializeBrokersVisited();
        this.brokersVisited.add((Object)brokerName);
    }

    public boolean hasVisited(String brokerName) {
        if (this.brokersVisited == null) {
            return false;
        }
        return this.brokersVisited.contains((Object)brokerName);
    }

    public String getBrokersVisitedAsString() {
        String result = "";
        if (this.brokersVisited != null && !this.brokersVisited.isEmpty()) {
            Iterator i = this.brokersVisited.iterator();
            while (i.hasNext()) {
                result = result + i.next().toString() + ",";
            }
        }
        return result;
    }

    public String toString() {
        return AbstractPacket.getPacketTypeAsString(this.getPacketType()) + ": " + this.getId();
    }

    protected static String getPacketTypeAsString(int type) {
        String packetTypeStr = "";
        switch (type) {
            case 6: {
                packetTypeStr = "ACTIVEMQ_MESSAGE";
                break;
            }
            case 7: {
                packetTypeStr = "ACTIVEMQ_TEXT_MESSAGE";
                break;
            }
            case 8: {
                packetTypeStr = "ACTIVEMQ_OBJECT_MESSAGE";
                break;
            }
            case 9: {
                packetTypeStr = "ACTIVEMQ_BYTES_MESSAGE";
                break;
            }
            case 10: {
                packetTypeStr = "ACTIVEMQ_STREAM_MESSAGE";
                break;
            }
            case 11: {
                packetTypeStr = "ACTIVEMQ_MAP_MESSAGE";
                break;
            }
            case 15: {
                packetTypeStr = "ACTIVEMQ_MSG_ACK";
                break;
            }
            case 16: {
                packetTypeStr = "RECEIPT_INFO";
                break;
            }
            case 17: {
                packetTypeStr = "CONSUMER_INFO";
                break;
            }
            case 18: {
                packetTypeStr = "PRODUCER_INFO";
                break;
            }
            case 19: {
                packetTypeStr = "TRANSACTION_INFO";
                break;
            }
            case 20: {
                packetTypeStr = "XA_TRANSACTION_INFO";
                break;
            }
            case 21: {
                packetTypeStr = "ACTIVEMQ_BROKER_INFO";
                break;
            }
            case 22: {
                packetTypeStr = "ACTIVEMQ_CONNECTION_INFO";
                break;
            }
            case 23: {
                packetTypeStr = "SESSION_INFO";
                break;
            }
            default: {
                packetTypeStr = "UNKNOWN PACKET TYPE: " + type;
            }
        }
        return packetTypeStr;
    }

    protected boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    protected void initializeOther(AbstractPacket other) {
        this.initializeBrokersVisited();
        other.id = this.id;
        other.receiptRequired = this.receiptRequired;
        other.memoryUsage = this.memoryUsage;
        CopyOnWriteArraySet set = this.brokersVisited;
        if (set != null && !set.isEmpty()) {
            other.brokersVisited = new CopyOnWriteArraySet((Collection)set);
        }
    }

    synchronized void initializeBrokersVisited() {
        if (this.brokersVisited == null) {
            this.brokersVisited = new CopyOnWriteArraySet();
        }
    }

    Object[] getBrokersVisited() {
        if (this.brokersVisited == null || this.brokersVisited.isEmpty()) {
            return null;
        }
        return this.brokersVisited.toArray();
    }

    public BitArray getBitArray() {
        return this.bitArray;
    }

    public void setBitArray(BitArray bitArray) {
        this.bitArray = bitArray;
    }
}

