/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.BrokerContainerFactory;

public class BrokerContext {
    private static final BrokerContext singleton;
    private Map brokersByName = new ConcurrentHashMap();
    private Map connectorsByURL = new ConcurrentHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static BrokerContext getInstance() {
        return singleton;
    }

    public synchronized BrokerContainer getBrokerContainerByName(String name, BrokerContainerFactory factory) throws JMSException {
        BrokerContainer container = (BrokerContainer)this.brokersByName.get(name);
        if (container == null) {
            container = factory.createBrokerContainer(name, this);
            if (!$assertionsDisabled && this.brokersByName.get(name) != container) {
                throw new AssertionError((Object)"Should have registered the container by now");
            }
            container.start();
        }
        return container;
    }

    public void registerContainer(String name, BrokerContainer container) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.brokersByName.put(name, container);
    }

    public void deregisterContainer(String name, BrokerContainer container) {
        this.brokersByName.remove(name);
    }

    public void registerConnector(String url, BrokerConnector connector) {
        this.connectorsByURL.put(url, connector);
    }

    public void deregisterConnector(String urlString) {
        this.connectorsByURL.remove(urlString);
    }

    public BrokerConnector getConnectorByURL(String url) {
        BrokerConnector brokerConnector = (BrokerConnector)this.connectorsByURL.get(url);
        if (brokerConnector == null) {
            if (url.startsWith("reliable:")) {
                return this.getConnectorByURL(url.substring("reliable:".length()));
            }
            if (url.startsWith("list:")) {
                return this.getConnectorByURL(url.substring("list:".length()));
            }
        }
        return brokerConnector;
    }

    static {
        $assertionsDisabled = !BrokerContext.class.desiredAssertionStatus();
        singleton = new BrokerContext();
    }
}

