/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker;

import java.util.List;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.DurableUnsubscribe;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.message.SessionInfo;
import org.codehaus.activemq.message.WireFormat;
import org.codehaus.activemq.security.SecurityAdapter;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.transport.DiscoveryAgent;
import org.codehaus.activemq.transport.NetworkConnector;
import org.codehaus.activemq.transport.TransportServerChannel;

public interface BrokerContainer
extends Service {
    public void registerConnection(BrokerClient var1, ConnectionInfo var2) throws JMSException;

    public void deregisterConnection(BrokerClient var1, ConnectionInfo var2) throws JMSException;

    public void registerMessageConsumer(BrokerClient var1, ConsumerInfo var2) throws JMSException;

    public void deregisterMessageConsumer(BrokerClient var1, ConsumerInfo var2) throws JMSException;

    public void registerMessageProducer(BrokerClient var1, ProducerInfo var2) throws JMSException;

    public void deregisterMessageProducer(BrokerClient var1, ProducerInfo var2) throws JMSException;

    public void registerSession(BrokerClient var1, SessionInfo var2) throws JMSException;

    public void deregisterSession(BrokerClient var1, SessionInfo var2) throws JMSException;

    public void startTransaction(BrokerClient var1, String var2) throws JMSException;

    public void rollbackTransaction(BrokerClient var1, String var2) throws JMSException;

    public void commitTransaction(BrokerClient var1, String var2) throws JMSException;

    public void sendTransactedMessage(BrokerClient var1, String var2, ActiveMQMessage var3) throws JMSException;

    public void acknowledgeTransactedMessage(BrokerClient var1, String var2, MessageAck var3) throws JMSException;

    public void sendMessage(BrokerClient var1, ActiveMQMessage var2) throws JMSException;

    public void acknowledgeMessage(BrokerClient var1, MessageAck var2) throws JMSException;

    public void durableUnsubscribe(BrokerClient var1, DurableUnsubscribe var2) throws JMSException;

    public void startTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public ActiveMQXid[] getPreparedTransactions(BrokerClient var1) throws XAException;

    public int prepareTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public void rollbackTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public void commitTransaction(BrokerClient var1, ActiveMQXid var2, boolean var3) throws XAException;

    public void addConnector(BrokerConnector var1);

    public void removeConnector(BrokerConnector var1);

    public Broker getBroker();

    public List getTransportConnectors();

    public void setTransportConnectors(List var1);

    public List getNetworkConnectors();

    public void setNetworkConnectors(List var1);

    public PersistenceAdapter getPersistenceAdapter();

    public void setPersistenceAdapter(PersistenceAdapter var1);

    public DiscoveryAgent getDiscoveryAgent();

    public void setDiscoveryAgent(DiscoveryAgent var1);

    public SecurityAdapter getSecurityAdapter();

    public void setSecurityAdapter(SecurityAdapter var1);

    public NetworkConnector addNetworkConnector(String var1);

    public NetworkConnector addNetworkConnector();

    public void addNetworkConnector(NetworkConnector var1);

    public void removeNetworkConnector(NetworkConnector var1);

    public void addConnector(String var1) throws JMSException;

    public void addConnector(String var1, WireFormat var2) throws JMSException;

    public void addConnector(TransportServerChannel var1);
}

