/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq;

import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQSession;
import org.codehaus.activemq.ActiveMQTopicSubscriber;
import org.codehaus.activemq.Closeable;
import org.codehaus.activemq.management.JMSConsumerStatsImpl;
import org.codehaus.activemq.management.StatsCapable;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.util.MemoryBoundedQueue;
import org.codehaus.activemq.selector.SelectorParser;

public class ActiveMQMessageConsumer
implements MessageConsumer,
StatsCapable,
Closeable {
    private static final Log log = LogFactory.getLog((Class)ActiveMQMessageConsumer.class);
    protected ActiveMQSession session;
    protected String consumerId;
    protected MemoryBoundedQueue messageQueue;
    protected String messageSelector;
    private MessageListener messageListener;
    protected String consumerName;
    protected ActiveMQDestination destination;
    private boolean closed;
    protected int consumerNumber;
    protected int prefetchNumber;
    protected long startTime;
    protected boolean noLocal;
    protected boolean browser;
    private Thread accessThread;
    private Object messageListenerGuard;
    private JMSConsumerStatsImpl stats;

    protected ActiveMQMessageConsumer(ActiveMQSession theSession, ActiveMQDestination dest, String name, String selector, int cnum, int prefetch, boolean noLocalValue, boolean browserValue) throws JMSException {
        if (dest == null) {
            throw new InvalidDestinationException("Do not understand a null destination");
        }
        if (dest.isTemporary()) {
            String physicalName = dest.getPhysicalName();
            if (physicalName == null) {
                throw new IllegalArgumentException("Physical name of Destination should be valid: " + dest);
            }
            String clientID = theSession.connection.getInitializedClientID();
            if (physicalName.indexOf(clientID) < 0) {
                throw new InvalidDestinationException("Cannot use a Temporary destination from another Connection");
            }
            if (dest.isDeleted()) {
                throw new InvalidDestinationException("Cannot use a Temporary destination that has been deleted");
            }
        }
        dest.incrementConsumerCounter();
        if (selector != null && (selector = selector.trim()).length() > 0) {
            new SelectorParser().parse(selector);
        }
        this.session = theSession;
        this.destination = dest;
        this.consumerName = name;
        this.messageSelector = selector;
        this.consumerNumber = cnum;
        this.prefetchNumber = prefetch;
        this.noLocal = noLocalValue;
        this.browser = browserValue;
        this.startTime = System.currentTimeMillis();
        this.messageListenerGuard = new Object();
        String queueName = theSession.connection.clientID + ":" + name;
        queueName = queueName + ":" + cnum;
        this.messageQueue = theSession.connection.getMemoryBoundedQueue(queueName);
        this.stats = new JMSConsumerStatsImpl(theSession.getSessionStats(), dest);
        this.session.addConsumer(this);
    }

    public long getLocalMemoryUsage() {
        return this.messageQueue.getLocalMemoryUsedByThisQueue();
    }

    public int size() {
        return this.messageQueue.size();
    }

    public Stats getStats() {
        return this.stats;
    }

    public JMSConsumerStatsImpl getConsumerStats() {
        return this.stats;
    }

    public String toString() {
        return "MessageConsumer: " + this.consumerId;
    }

    public int getPrefetchNumber() {
        return this.prefetchNumber;
    }

    public void setPrefetchNumber(int prefetchNumber) {
        this.prefetchNumber = prefetchNumber;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.messageListener = listener;
        if (listener != null) {
            this.session.setSessionConsumerDispatchState(2);
        }
    }

    public Message receive() throws JMSException {
        this.checkClosed();
        this.session.setSessionConsumerDispatchState(3);
        try {
            this.accessThread = Thread.currentThread();
            ActiveMQMessage message = (ActiveMQMessage)this.messageQueue.dequeue();
            this.accessThread = null;
            if (message != null) {
                this.messageDelivered(message, true);
                message = message.shallowCopy();
            }
            return message;
        }
        catch (InterruptedException ioe) {
            return null;
        }
    }

    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        this.session.setSessionConsumerDispatchState(3);
        try {
            if (timeout == 0L) {
                return this.receive();
            }
            this.accessThread = Thread.currentThread();
            ActiveMQMessage message = (ActiveMQMessage)this.messageQueue.dequeue(timeout);
            this.accessThread = null;
            if (message != null) {
                this.messageDelivered(message, true);
                message = message.shallowCopy();
            }
            return message;
        }
        catch (InterruptedException ioe) {
            return null;
        }
    }

    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        this.session.setSessionConsumerDispatchState(3);
        try {
            ActiveMQMessage message = (ActiveMQMessage)this.messageQueue.dequeueNoWait();
            if (message != null) {
                this.messageDelivered(message, true);
                return message.shallowCopy();
            }
        }
        catch (InterruptedException ioe) {
            throw new JMSException("Queue is interrupted: " + ioe.getMessage());
        }
        return null;
    }

    public void close() throws JMSException {
        try {
            this.accessThread.interrupt();
        }
        catch (NullPointerException npe) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.destination != null) {
            this.destination.decrementConsumerCounter();
        }
        this.session.removeConsumer(this);
        this.messageQueue.close();
        this.closed = true;
    }

    public boolean isDurableSubscriber() {
        return this instanceof ActiveMQTopicSubscriber && this.consumerName != null && this.consumerName.length() > 0;
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(ActiveMQMessage message) {
        message.setConsumerId(this.consumerId);
        MessageListener listener = null;
        Object object = this.messageListenerGuard;
        synchronized (object) {
            listener = this.messageListener;
        }
        try {
            if (!this.closed) {
                if (listener != null) {
                    this.messageDelivered(message, true);
                    listener.onMessage((Message)message.shallowCopy());
                } else {
                    this.messageQueue.enqueue(message);
                }
            } else {
                this.messageDelivered(message, false);
            }
        }
        catch (Exception e) {
            log.warn((Object)("could not process message: " + message), (Throwable)e);
            this.messageDelivered(message, false);
        }
    }

    protected String getConsumerId() {
        return this.consumerId;
    }

    protected void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    protected String getConsumerName() {
        return this.consumerName;
    }

    protected void setConsumerName(String value) {
        this.consumerName = value;
    }

    protected int getConsumerNumber() {
        return this.consumerNumber;
    }

    protected void setConsumerNumber(int value) {
        this.consumerNumber = value;
    }

    protected boolean isNoLocal() {
        return this.noLocal;
    }

    protected boolean isBrowser() {
        return this.browser;
    }

    protected void setBrowser(boolean value) {
        this.browser = value;
    }

    protected ActiveMQDestination getDestination() {
        return this.destination;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void clearMessagesInProgress() {
        this.messageQueue.clear();
    }

    private void messageDelivered(ActiveMQMessage message, boolean messageRead) {
        boolean read;
        boolean bl = read = this.browser ? false : messageRead;
        if (message != null) {
            message.setTransientConsumed(!this.isDurableSubscriber() && message.getJMSActiveMQDestination().isTopic());
            this.session.messageDelivered(this.isDurableSubscriber() || this.destination.isQueue(), message, read);
            if (messageRead) {
                this.stats.onMessage(message);
            }
        }
    }
}

